/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.DomainPart;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class PlantUMLBoundedContextClassDiagramCreator
extends AbstractPlantUMLClassDiagramCreator<BoundedContext>
implements PlantUMLDiagramCreator<BoundedContext> {
    @Override
    protected void printDiagramContent(BoundedContext boundedContext) {
        this.relationships = Lists.newArrayList();
        this.extensions = Lists.newArrayList();
        this.domainObjects = EcoreUtil2.getAllContentsOfType((EObject)boundedContext, SimpleDomainObject.class);
        if (this.domainObjects.size() <= 0) {
            this.printEmptyDiagramNote();
            return;
        }
        for (SculptorModule module : boundedContext.getModules()) {
            this.printModule(module);
        }
        for (Aggregate aggregate : boundedContext.getAggregates()) {
            this.printAggregate(aggregate, 0);
        }
        this.printReferences(0);
        this.printLegend(boundedContext);
    }

    private void printLegend(BoundedContext boundedContext) {
        List<Subdomain> subdomains = this.getSubdomains((List<DomainPart>)boundedContext.getImplementedDomainParts());
        if (subdomains.isEmpty() && boundedContext.getRefinedBoundedContext() == null) {
            return;
        }
        this.sb.append("legend left");
        this.linebreak();
        if (boundedContext.getRefinedBoundedContext() != null) {
            this.sb.append("  ").append("This Bounded Context '").append(boundedContext.getName()).append("' refines the '").append(boundedContext.getRefinedBoundedContext().getName()).append("' Bounded Context.");
            this.linebreak();
        }
        for (Subdomain subdomain : subdomains) {
            if (subdomain.getEntities().isEmpty()) {
                this.sb.append("  ").append("This bounded context implements the subdomain '" + subdomain.getName() + "'.");
            } else {
                this.sb.append("  ").append("This bounded context implements the subdomain '" + subdomain.getName() + "', which contains the following entities:");
            }
            this.linebreak();
            for (Entity entity : subdomain.getEntities()) {
                this.sb.append("  ").append(" - ").append(entity.getName());
                this.linebreak();
            }
        }
        this.sb.append("end legend");
        this.linebreak();
    }

    private void printEmptyDiagramNote() {
        this.sb.append("note").append(" ").append("\"").append("Sorry, we cannot generate a class diagram for this Bounded Context. There are no Aggregates or none of the Aggregates contain any domain objects (entities, value objects or domain events).").append("\"").append(" as EmptyDiagramError");
        this.linebreak();
    }

    private void printModule(SculptorModule module) {
        this.sb.append("package ");
        if (module.getBasePackage() != null && !"".equals(module.getBasePackage())) {
            this.sb.append(module.getBasePackage()).append(".").append(module.getName());
        } else {
            this.sb.append(module.getName());
        }
        this.sb.append(" {");
        this.linebreak();
        for (Aggregate aggregate : module.getAggregates()) {
            this.printAggregate(aggregate, 1);
        }
        for (SimpleDomainObject simpleDomainObject : module.getDomainObjects()) {
            this.printDomainObject(simpleDomainObject, 1);
        }
        for (Service service : module.getServices()) {
            this.printService(service, 1);
        }
        this.sb.append("}");
        this.linebreak();
    }

    private void printAggregate(Aggregate aggregate, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("package ").append("\"'").append(aggregate.getName()).append("' ").append("Aggregate\"").append(" <<Rectangle>> ").append("{");
        this.linebreak();
        for (SimpleDomainObject domainObject : aggregate.getDomainObjects()) {
            this.printDomainObject(domainObject, indentation + 1);
        }
        for (Service service : aggregate.getServices()) {
            this.printService(service, indentation + 1);
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printService(Service service, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("class").append(" ").append(service.getName());
        this.sb.append(" <<(S,DarkSeaGreen) Service>> ");
        this.sb.append("{");
        this.linebreak();
        this.printServiceOperations(service.getName(), (List<ServiceOperation>)service.getOperations(), indentation + 1);
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printServiceOperations(String objectName, List<ServiceOperation> operations, int indentation) {
        for (ServiceOperation operation : operations) {
            this.printOperation(objectName, operation.getName(), operation.getReturnType(), (List<Parameter>)operation.getParameters(), indentation);
        }
    }

    private List<Subdomain> getSubdomains(List<DomainPart> domainParts) {
        ArrayList subdomains = Lists.newArrayList();
        domainParts.forEach(domainPart -> {
            if (domainPart instanceof Domain) {
                subdomains.addAll(((Domain)domainPart).getSubdomains());
            } else {
                subdomains.add((Subdomain)domainPart);
            }
        });
        return subdomains;
    }
}

