/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.userrepresentations;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Aggregate;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.AvailabilityCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Compatibilities;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ConsistencyCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ContentVolatility;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Entity;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.PredefinedService;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SecurityAccessGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SecurityCriticality;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SeparatedSecurityZone;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterConfigurationDSLFactory;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SharedOwnerGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.StorageSimilarity;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.StructuralVolatility;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class UserRepresentationsExampleFactory {
    private static final int MAX_ENTITY_USECASE_EXAMPLES = 4;
    private ServiceCutterConfigurationDSLFactory factory = ServiceCutterConfigurationDSLFactory.eINSTANCE;
    private ContextMappingModel contextMappingModel;
    private List<Attribute> allModelAttributes;

    public ServiceCutterUserRepresentationsModel createExampleModel(ContextMappingModel contextMappingModel) {
        ServiceCutterUserRepresentationsModel model = this.factory.createServiceCutterUserRepresentationsModel();
        this.contextMappingModel = contextMappingModel;
        this.allModelAttributes = this.collectAttributes(contextMappingModel);
        if (this.allModelAttributes.size() <= 0) {
            UseCase dummyUseCase = this.factory.createUseCase();
            dummyUseCase.setName("NoDataFound");
            dummyUseCase.setDoc("/* Your context map should at least contain one bounded context with aggregates, entities and some attributes. \n * Otherwise it is not possible to generate user representation examples. */");
            model.getUseCases().add((Object)dummyUseCase);
            return model;
        }
        List<UseCase> useCases = this.createSampleUseCases();
        if (useCases.size() > 0) {
            useCases.get(0).setDoc("/* The following usecases are just examples to give you a hint how to specify them! You may want to change or remove them. */");
        }
        model.getUseCases().addAll(useCases);
        model.setCompatibilities(this.createSampleCompatibilities());
        model.getAggregates().addAll(this.createSampleAggregates());
        model.getEntities().addAll(this.createSampleEntities());
        model.getPredefinedServices().addAll(this.createSamplePredefinedServices());
        model.getSecurityAccessGroups().addAll(this.createSampleSecurityAccessGroups());
        model.getSeparatedSecurityZones().addAll(this.createSampleSeparatedSecurityZones());
        model.getSharedOwnerGroups().addAll(this.createSampleSharedOwnerGroups());
        return model;
    }

    private List<UseCase> createSampleUseCases() {
        ArrayList useCases = Lists.newArrayList();
        List<DomainObject> domainObjects = this.collectDomainObjects();
        for (DomainObject domainObject : domainObjects) {
            if (useCases.size() >= 4) break;
            useCases.addAll(this.createEntityUseCases(domainObject));
        }
        return useCases;
    }

    private List<UseCase> createEntityUseCases(DomainObject domainObject) {
        ArrayList useCases = Lists.newArrayList();
        UseCase viewUseCase = this.factory.createUseCase();
        viewUseCase.setName("View" + domainObject.getName());
        viewUseCase.getNanoentitiesRead().addAll(this.collectNanoEntities(domainObject));
        useCases.add(viewUseCase);
        UseCase updateUseCase = this.factory.createUseCase();
        updateUseCase.setName("Update" + domainObject.getName());
        updateUseCase.getNanoentitiesWritten().addAll(this.collectNanoEntities(domainObject));
        useCases.add(updateUseCase);
        return useCases;
    }

    private List<String> collectNanoEntities(DomainObject domainObject) {
        ArrayList nanoEntities = Lists.newArrayList();
        for (Attribute attribute : domainObject.getAttributes()) {
            nanoEntities.add(domainObject.getName() + "." + attribute.getName());
        }
        for (Reference reference : domainObject.getReferences()) {
            nanoEntities.add(reference.getDomainObjectType().getName() + "." + reference.getName());
        }
        return nanoEntities;
    }

    private Compatibilities createSampleCompatibilities() {
        Compatibilities compatibilities = this.factory.createCompatibilities();
        compatibilities.setDoc("/* Compatibilities can be used to import all coupling criteria of type Compatability.\n * https://github.com/ServiceCutter/ServiceCutter/wiki/Compatibilities\n * The following compatibilities are just examples to provide you a template! You have to specify or remove them.  */");
        if (this.allModelAttributes.size() <= 0) {
            return compatibilities;
        }
        ContentVolatility exampleContentVolatility = this.factory.createContentVolatility();
        exampleContentVolatility.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-8-Content-Volatility */");
        exampleContentVolatility.setCharacteristic("Often");
        exampleContentVolatility.setCharacteristicDoc("// Allowed characteristics: Often, Regularly, Rarely");
        exampleContentVolatility.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleContentVolatility.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getContentVolatility().add((Object)exampleContentVolatility);
        StructuralVolatility exampleStructuralVolatility = this.factory.createStructuralVolatility();
        exampleStructuralVolatility.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-4-Structural-Volatility */");
        exampleStructuralVolatility.setCharacteristic("Normal");
        exampleStructuralVolatility.setCharacteristicDoc("// Allowed characteristics: Often, Normal, Rarely");
        exampleStructuralVolatility.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleStructuralVolatility.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getStructuralVolatility().add((Object)exampleStructuralVolatility);
        AvailabilityCriticality exampleAvailabilityCriticality = this.factory.createAvailabilityCriticality();
        exampleAvailabilityCriticality.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-7-Availability-Criticality */");
        exampleAvailabilityCriticality.setCharacteristic("Normal");
        exampleAvailabilityCriticality.setCharacteristicDoc("// Allowed characteristics: Critical, Normal, Low");
        exampleAvailabilityCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleAvailabilityCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getAvailabilityCriticality().add((Object)exampleAvailabilityCriticality);
        ConsistencyCriticality exampleConsistencyCriticality = this.factory.createConsistencyCriticality();
        exampleConsistencyCriticality.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-6-Consistency-Criticality */");
        exampleConsistencyCriticality.setCharacteristic("Eventually");
        exampleConsistencyCriticality.setCharacteristicDoc("// Allowed characteristics: High, Eventually, Weak");
        exampleConsistencyCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleConsistencyCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getConsistencyCriticality().add((Object)exampleConsistencyCriticality);
        StorageSimilarity exampleStorageSimilarity = this.factory.createStorageSimilarity();
        exampleStorageSimilarity.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-11-Storage-Similarity */");
        exampleStorageSimilarity.setCharacteristic("Normal");
        exampleStorageSimilarity.setCharacteristicDoc("// Allowed characteristics: Tiny, Normal, Huge");
        exampleStorageSimilarity.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleStorageSimilarity.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getStorageSimilarity().add((Object)exampleStorageSimilarity);
        SecurityCriticality exampleSecurityCriticality = this.factory.createSecurityCriticality();
        exampleSecurityCriticality.setDoc("/* See: https://github.com/ServiceCutter/ServiceCutter/wiki/CC-15-Security-Criticality */");
        exampleSecurityCriticality.setCharacteristic("Internal");
        exampleSecurityCriticality.setCharacteristicDoc("// Allowed characteristics: Critical, Internal, Public");
        exampleSecurityCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        exampleSecurityCriticality.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
        compatibilities.getSecurityCriticality().add((Object)exampleSecurityCriticality);
        return compatibilities;
    }

    private List<Aggregate> createSampleAggregates() {
        List<org.contextmapper.dsl.contextMappingDSL.Aggregate> existingAggregates = this.collectAggregates();
        ArrayList aggregates = Lists.newArrayList();
        if (existingAggregates.size() > 0) {
            for (org.contextmapper.dsl.contextMappingDSL.Aggregate aggregate : existingAggregates) {
                List<Attribute> aggregateAttributes = this.collectAttributes(aggregate);
                Aggregate scAggregate = this.factory.createAggregate();
                scAggregate.setName(aggregate.getName());
                scAggregate.setDoc("/* This aggregate was generated by your CML model. You do not have to change it. */");
                scAggregate.getNanoentities().addAll(this.convertAttributesToNanoEntites(aggregateAttributes));
                aggregates.add(scAggregate);
            }
        } else if (this.allModelAttributes.size() > 0) {
            Aggregate sampleAggregate = this.factory.createAggregate();
            sampleAggregate.setDoc("/* This is just a sample aggregate (template). \n* Note that if your CML model had Aggregates within the Bounded Contexts, they would have been generated at this place! */");
            sampleAggregate.setName("SampleAggregate");
            sampleAggregate.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            sampleAggregate.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            aggregates.add(sampleAggregate);
        }
        return aggregates;
    }

    private List<Entity> createSampleEntities() {
        return Lists.newArrayList();
    }

    private List<PredefinedService> createSamplePredefinedServices() {
        ArrayList predefinedServices = Lists.newArrayList();
        for (BoundedContext boundedContext : this.contextMappingModel.getMap().getBoundedContexts()) {
            List<Attribute> attributes = this.collectAttributes(boundedContext);
            PredefinedService predefinedService = this.factory.createPredefinedService();
            predefinedService.setName(boundedContext.getName());
            predefinedService.setDoc("/* This predefined service is based on your '" + boundedContext.getName() + "' BoundedContext. You do not have to change it. */");
            predefinedService.getNanoentities().addAll(this.convertAttributesToNanoEntites(attributes));
            predefinedServices.add(predefinedService);
        }
        return predefinedServices;
    }

    private List<SecurityAccessGroup> createSampleSecurityAccessGroups() {
        ArrayList securityAccessGroups = Lists.newArrayList();
        if (this.allModelAttributes.size() > 0) {
            SecurityAccessGroup exampleSecurityAccessGroup = this.factory.createSecurityAccessGroup();
            exampleSecurityAccessGroup.setName("SecurityAccessGroupTemplate");
            exampleSecurityAccessGroup.setDoc("/* Security Accress Groups cannot be derived from ContextMap. \n * This is a template/example how you can define them. If you do not want to specify any, remove this block. */");
            exampleSecurityAccessGroup.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            exampleSecurityAccessGroup.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            securityAccessGroups.add(exampleSecurityAccessGroup);
        }
        return securityAccessGroups;
    }

    private List<SeparatedSecurityZone> createSampleSeparatedSecurityZones() {
        ArrayList separatedSecurityZones = Lists.newArrayList();
        if (this.allModelAttributes.size() > 0) {
            SeparatedSecurityZone exampleSeparatedSecurityZone = this.factory.createSeparatedSecurityZone();
            exampleSeparatedSecurityZone.setName("SeparatedSecurityZoneTemplate");
            exampleSeparatedSecurityZone.setDoc("/* Separated Security Zones cannot be derived from ContextMap. \n * This is a template/example how you can define them. If you do not want to specify any, remove this block. */");
            exampleSeparatedSecurityZone.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            exampleSeparatedSecurityZone.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            separatedSecurityZones.add(exampleSeparatedSecurityZone);
        }
        return separatedSecurityZones;
    }

    private List<SharedOwnerGroup> createSampleSharedOwnerGroups() {
        ArrayList sharedOwnerGroups = Lists.newArrayList();
        if (this.allModelAttributes.size() > 0) {
            SharedOwnerGroup exampleSharedOwnerGroup = this.factory.createSharedOwnerGroup();
            exampleSharedOwnerGroup.setName("SharedOwnerGroupTemplate");
            exampleSharedOwnerGroup.setDoc("/* Shared Owner Groups cannot be derived from ContextMap. \n * This is a template/example how you can define them. If you do not want to specify any, remove this block. */");
            exampleSharedOwnerGroup.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            exampleSharedOwnerGroup.getNanoentities().add((Object)this.randomlyPickAttribute(this.allModelAttributes));
            sharedOwnerGroups.add(exampleSharedOwnerGroup);
        }
        return sharedOwnerGroups;
    }

    private List<org.contextmapper.dsl.contextMappingDSL.Aggregate> collectAggregates() {
        return EcoreUtil2.getAllContentsOfType((EObject)this.contextMappingModel, org.contextmapper.dsl.contextMappingDSL.Aggregate.class);
    }

    private List<DomainObject> collectDomainObjects() {
        ArrayList list = Lists.newArrayList();
        list.addAll(EcoreUtil2.getAllContentsOfType((EObject)this.contextMappingModel, org.contextmapper.tactic.dsl.tacticdsl.Entity.class));
        list.addAll(EcoreUtil2.getAllContentsOfType((EObject)this.contextMappingModel, ValueObject.class));
        list.addAll(EcoreUtil2.getAllContentsOfType((EObject)this.contextMappingModel, DomainEvent.class));
        return list;
    }

    private List<Attribute> collectAttributes(ContextMappingModel rootModel) {
        ArrayList attributes = Lists.newArrayList();
        if (rootModel.getMap() == null) {
            return attributes;
        }
        for (BoundedContext bc : rootModel.getMap().getBoundedContexts()) {
            attributes.addAll(EcoreUtil2.getAllContentsOfType((EObject)bc, Attribute.class));
        }
        return attributes;
    }

    private List<Attribute> collectAttributes(EObject root) {
        return EcoreUtil2.getAllContentsOfType((EObject)root, Attribute.class);
    }

    private String randomlyPickAttribute(List<Attribute> attributes) {
        Random random = new Random();
        if (attributes.size() > 0) {
            return this.createNanoEntityString(attributes.get(random.nextInt(attributes.size())));
        }
        return "";
    }

    private String createNanoEntityString(Attribute attribute) {
        DomainObject domainObject = (DomainObject)attribute.eContainer();
        return domainObject.getName() + "." + attribute.getName();
    }

    private List<String> convertAttributesToNanoEntites(List<Attribute> attributes) {
        ArrayList nanoEntities = Lists.newArrayList();
        for (Attribute attribute : attributes) {
            nanoEntities.add(this.createNanoEntityString(attribute));
        }
        return nanoEntities;
    }
}

