/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.henshin;

import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.henshin.HenshinTransformationFileProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public abstract class AbstractHenshinRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    @Override
    protected void doRefactor() {
        this.executeHenshinTransformation();
    }

    private void executeHenshinTransformation() {
        HenshinResourceSet resourceSet = new HenshinResourceSet();
        String transformationFile = new HenshinTransformationFileProvider().getTransformationFilePath(this.getHenshinTransformationFilename());
        Module module = resourceSet.getModule(transformationFile, false);
        CMLResourceContainer transformationResource = this.getTransformationResource();
        EGraphImpl graph = new EGraphImpl(transformationResource.getResource());
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl refactoringUnit = new UnitApplicationImpl((Engine)engine);
        refactoringUnit.setEGraph((EGraph)graph);
        refactoringUnit.setUnit(module.getUnit(this.getTransformationUnitName()));
        this.setUnitParameters((UnitApplication)refactoringUnit);
        if (!refactoringUnit.execute(null)) {
            this.throwTransformationError();
        }
        transformationResource.getResource().getContents().clear();
        transformationResource.getResource().getContents().add((Object)((EObject)graph.getRoots().get(0)));
        this.postProcessing(transformationResource);
    }

    protected abstract CMLResourceContainer getTransformationResource();

    protected abstract String getHenshinTransformationFilename();

    protected abstract String getTransformationUnitName();

    protected void setUnitParameters(UnitApplication refactoringUnit) {
    }

    protected void postProcessing(CMLResourceContainer resource) {
    }

    protected void throwTransformationError() {
        throw new RuntimeException("Error in Henshin transformation. Refactoring could not be executed ...");
    }
}

