/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class UserRequirementsValidator
extends AbstractDeclarativeValidator {
    private static final String NANOENTITY_FORMAT_REGEX = "[A-Z]{1}[a-zA-Z0-9_]*\\.[a-z]{1}[a-zA-Z0-9_]*";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateFeature(Feature feature) {
        if (feature.getEntity() == null) {
            return;
        }
        if (!feature.getEntity().matches("^[a-zA-Z_][a-zA-Z0-9_]*")) {
            this.warning("The entity name should consist of the following characters: a-z, A-Z, 0-9, _. Please rename the entity accordingly before applying transformations.", feature, (EStructuralFeature)ContextMappingDSLPackage.Literals.FEATURE__ENTITY);
        }
        if (feature.getVerb() == null) {
            return;
        }
        if (!feature.getVerb().matches("^[a-zA-Z_][a-zA-Z0-9_]*")) {
            this.warning("The verb should consist of the following characters: a-z, A-Z, 0-9, _. Please rename it accordingly before applying transformations.", feature, (EStructuralFeature)ContextMappingDSLPackage.Literals.FEATURE__VERB);
        }
    }

    @Check
    public void validateNanoentityStrings(UserRequirement userRequirement) {
        if (!userRequirement.getNanoentitiesRead().isEmpty()) {
            this.validateNanoentityNamesList(userRequirement, (List<String>)userRequirement.getNanoentitiesRead(), ContextMappingDSLPackage.Literals.USER_REQUIREMENT__NANOENTITIES_READ);
        }
        if (!userRequirement.getNanoentitiesWritten().isEmpty()) {
            this.validateNanoentityNamesList(userRequirement, (List<String>)userRequirement.getNanoentitiesWritten(), ContextMappingDSLPackage.Literals.USER_REQUIREMENT__NANOENTITIES_WRITTEN);
        }
    }

    private void validateNanoentityNamesList(UserRequirement userRequirement, List<String> nanoEntities, EAttribute attribute) {
        for (int i = 0; i < nanoEntities.size(); ++i) {
            if (nanoEntities.get(i).matches(NANOENTITY_FORMAT_REGEX)) continue;
            this.error(String.format("The string '%s' does not match the format of a Nanoentity. Please use the following format: 'Entity.attribute' (Example: 'Customer.firstName')", nanoEntities.get(i)), userRequirement, (EStructuralFeature)attribute, i);
        }
    }
}

