/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.FixedArrayList;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.util.Filter;
import org.graphstream.util.FilteredEdgeIterator;
import org.graphstream.util.FilteredNodeIterator;
import org.graphstream.util.Filters;

public class ConnectedComponents
extends SinkAdapter
implements DynamicAlgorithm,
Iterable<ConnectedComponent> {
    private HashMap<Node, Integer> connectedComponentsMap;
    protected Graph graph;
    protected int connectedComponents = 0;
    protected HashMap<Integer, Integer> connectedComponentsSize;
    protected FixedArrayList<String> ids = new FixedArrayList();
    protected FixedArrayList<ConnectedComponent> components = new FixedArrayList();
    protected boolean started = false;
    protected String cutAttribute = null;
    protected String countAttribute = null;

    public ConnectedComponents() {
        this(null);
    }

    public ConnectedComponents(Graph graph) {
        this.ids.add("");
        if (graph != null) {
            this.init(graph);
        }
    }

    public List<Node> getGiantComponent() {
        if (!this.started) {
            this.compute();
        }
        int maxSize = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (Integer c : this.connectedComponentsSize.keySet()) {
            if (this.connectedComponentsSize.get(c) <= maxSize) continue;
            maxSize = this.connectedComponentsSize.get(c);
            maxIndex = c;
        }
        if (maxIndex != -1) {
            ArrayList<Node> giant = new ArrayList<Node>();
            for (Node n : this.graph.getNodeSet()) {
                if (this.connectedComponentsMap.get(n) != maxIndex) continue;
                giant.add(n);
            }
            return giant;
        }
        return null;
    }

    public int getConnectedComponentsCount() {
        return this.getConnectedComponentsCount(1);
    }

    public int getConnectedComponentsCount(int sizeThreshold) {
        return this.getConnectedComponentsCount(sizeThreshold, 0);
    }

    public int getConnectedComponentsCount(int sizeThreshold, int sizeCeiling) {
        if (!this.started) {
            this.compute();
        }
        if (sizeThreshold <= 1 && sizeCeiling <= 0) {
            return this.connectedComponents;
        }
        int count = 0;
        for (Integer c : this.connectedComponentsSize.keySet()) {
            if (this.connectedComponentsSize.get(c) < sizeThreshold || sizeCeiling > 0 && this.connectedComponentsSize.get(c) >= sizeCeiling) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<ConnectedComponent> iterator() {
        while (this.components.size() > this.connectedComponents) {
            this.components.remove(this.components.getLastIndex());
        }
        return this.components.iterator();
    }

    protected int addIdentifier() {
        this.ids.add("");
        return this.ids.getLastIndex();
    }

    protected void removeIdentifier(int identifier) {
        this.ids.remove(identifier);
    }

    public void setCutAttribute(String cutAttribute) {
        this.cutAttribute = cutAttribute;
        this.compute();
    }

    public void setCountAttribute(String countAttribute) {
        this.removeMarks();
        this.countAttribute = countAttribute;
        this.remapMarks();
    }

    protected void removeMarks() {
        Iterator nodes = this.graph.getNodeIterator();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            if (this.countAttribute != null) continue;
            node.removeAttribute(this.countAttribute);
        }
    }

    protected void remapMarks() {
        if (this.countAttribute != null && this.connectedComponentsMap != null) {
            Iterator nodes = this.graph.getNodeIterator();
            while (nodes.hasNext()) {
                Node v = (Node)nodes.next();
                int id = this.connectedComponentsMap.get(v);
                v.addAttribute(this.countAttribute, new Object[]{id - 1});
            }
        }
    }

    @Override
    public void init(Graph graph) {
        if (this.graph != null) {
            this.graph.removeSink((Sink)this);
        }
        this.graph = graph;
        this.graph.addSink((Sink)this);
    }

    @Override
    public void compute() {
        this.connectedComponents = 0;
        this.started = true;
        this.ids.clear();
        this.ids.add("");
        this.components.add(new ConnectedComponent(0));
        this.connectedComponentsMap = new HashMap();
        this.connectedComponentsSize = new HashMap();
        Iterator nodes = this.graph.getNodeIterator();
        while (nodes.hasNext()) {
            this.connectedComponentsMap.put((Node)nodes.next(), 0);
        }
        nodes = this.graph.getNodeIterator();
        while (nodes.hasNext()) {
            Node v = (Node)nodes.next();
            if (this.connectedComponentsMap.get(v) != 0) continue;
            ++this.connectedComponents;
            int newIdentifier = this.addIdentifier();
            int size = this.computeConnectedComponent(v, newIdentifier, null);
            if (size > 0) {
                this.components.add(new ConnectedComponent(newIdentifier));
            }
            this.connectedComponentsSize.put(newIdentifier, size);
        }
        this.remapMarks();
    }

    @Override
    public void terminate() {
        if (this.graph != null) {
            this.graph.removeSink((Sink)this);
            this.graph = null;
            this.started = false;
            this.connectedComponents = 0;
            this.connectedComponentsSize.clear();
        }
    }

    private int computeConnectedComponent(Node v, int id, Edge exception) {
        int size = 0;
        LinkedList<Node> open = new LinkedList<Node>();
        open.add(v);
        while (!open.isEmpty()) {
            Node n = (Node)open.remove();
            this.connectedComponentsMap.put(n, id);
            ++size;
            this.markNode(n, id);
            Iterator edges = n.getEdgeIterator();
            while (edges.hasNext()) {
                Node n2;
                Edge e = (Edge)edges.next();
                if (e == exception || this.cutAttribute != null && e.hasAttribute(this.cutAttribute) || this.connectedComponentsMap.get(n2 = e.getOpposite(n)) == id) continue;
                open.add(n2);
                this.connectedComponentsMap.put(n2, id);
                this.markNode(n2, id);
            }
        }
        return size;
    }

    protected void markNode(Node node, int id) {
        if (this.countAttribute != null) {
            node.addAttribute(this.countAttribute, new Object[]{id - 1});
        }
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Edge edge;
        if (!this.started && this.graph != null) {
            this.compute();
        } else if (this.started && (edge = this.graph.getEdge(edgeId)) != null && !this.connectedComponentsMap.get(edge.getNode0()).equals(this.connectedComponentsMap.get(edge.getNode1()))) {
            --this.connectedComponents;
            int id0 = this.connectedComponentsMap.get(edge.getNode0());
            int id1 = this.connectedComponentsMap.get(edge.getNode1());
            this.computeConnectedComponent(edge.getNode1(), id0, edge);
            this.removeIdentifier(id1);
            this.connectedComponentsSize.put(id0, this.connectedComponentsSize.get(id0) + this.connectedComponentsSize.get(id1));
            this.connectedComponentsSize.remove(id1);
        }
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        Node node;
        if (!this.started && this.graph != null) {
            this.compute();
        } else if (this.started && (node = this.graph.getNode(nodeId)) != null) {
            ++this.connectedComponents;
            int id = this.addIdentifier();
            this.connectedComponentsMap.put(node, id);
            this.markNode(node, id);
            this.connectedComponentsSize.put(id, 1);
        }
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        Edge edge;
        if (!this.started && this.graph != null) {
            this.compute();
        }
        if (this.started && (edge = this.graph.getEdge(edgeId)) != null) {
            int id = this.addIdentifier();
            int oldId = this.connectedComponentsMap.get(edge.getNode0());
            int oldSize = this.connectedComponentsSize.get(oldId);
            int newSize = this.computeConnectedComponent(edge.getNode0(), id, edge);
            if (!this.connectedComponentsMap.get(edge.getNode0()).equals(this.connectedComponentsMap.get(edge.getNode1()))) {
                if (newSize > 0) {
                    this.connectedComponentsSize.put(id, newSize);
                    ++this.connectedComponents;
                }
                if (oldSize - newSize > 0) {
                    this.connectedComponentsSize.put(oldId, oldSize - newSize);
                } else {
                    this.connectedComponentsSize.remove(oldId);
                    --this.connectedComponents;
                }
            } else {
                this.removeIdentifier(oldId);
                this.connectedComponentsSize.put(id, this.connectedComponentsSize.get(oldId));
                this.connectedComponentsSize.remove(oldId);
            }
        }
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        Node node;
        if (!this.started && this.graph != null) {
            this.compute();
        }
        if (this.started && (node = this.graph.getNode(nodeId)) != null) {
            this.connectedComponentsSize.remove(this.connectedComponentsMap.get(node));
            --this.connectedComponents;
            this.removeIdentifier(this.connectedComponentsMap.get(node));
        }
    }

    public void graphCleared(String graphId, long timeId) {
        if (this.started) {
            this.connectedComponents = 0;
            this.ids.clear();
            this.ids.add("");
            this.components.clear();
            this.components.add(new ConnectedComponent(0));
            this.connectedComponentsMap.clear();
            this.connectedComponentsSize.clear();
        }
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (this.cutAttribute != null && attribute.equals(this.cutAttribute)) {
            if (!this.started && this.graph != null) {
                this.compute();
            }
            Edge edge = this.graph.getEdge(edgeId);
            int id = this.addIdentifier();
            int oldId = this.connectedComponentsMap.get(edge.getNode0());
            int oldSize = this.connectedComponentsSize.get(oldId);
            int newSize = this.computeConnectedComponent(edge.getNode0(), id, edge);
            if (!this.connectedComponentsMap.get(edge.getNode0()).equals(this.connectedComponentsMap.get(edge.getNode1()))) {
                if (newSize > 0) {
                    this.connectedComponentsSize.put(id, newSize);
                    ++this.connectedComponents;
                }
                if (oldSize - newSize > 0) {
                    this.connectedComponentsSize.put(oldId, oldSize - newSize);
                } else {
                    this.connectedComponentsSize.remove(oldId);
                    --this.connectedComponents;
                }
            } else {
                this.removeIdentifier(oldId);
                this.connectedComponentsSize.put(id, this.connectedComponentsSize.get(oldId));
                this.connectedComponentsSize.remove(oldId);
            }
        }
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        if (this.cutAttribute != null && attribute.equals(this.cutAttribute)) {
            Edge edge;
            if (!this.started && this.graph != null) {
                this.compute();
            }
            if (!this.connectedComponentsMap.get((edge = this.graph.getEdge(edgeId)).getNode0()).equals(this.connectedComponentsMap.get(edge.getNode1()))) {
                --this.connectedComponents;
                int id0 = this.connectedComponentsMap.get(edge.getNode0());
                int id1 = this.connectedComponentsMap.get(edge.getNode1());
                this.computeConnectedComponent(edge.getNode1(), id0, edge);
                this.removeIdentifier(id1);
                this.connectedComponentsSize.put(id0, this.connectedComponentsSize.get(id0) + this.connectedComponentsSize.get(id1));
                this.connectedComponentsSize.remove(id1);
            }
        }
    }

    private static class EdgeFilter
    implements Filter<Edge> {
        Filter<Node> f;

        public EdgeFilter(Filter<Node> f) {
            this.f = f;
        }

        public boolean isAvailable(Edge e) {
            return this.f.isAvailable((Element)e.getNode0()) && this.f.isAvailable((Element)e.getNode1());
        }
    }

    public class ConnectedComponent
    implements Iterable<Node> {
        public final Integer id;
        Filter<Node> nodeFilter;
        Filter<Edge> edgeFilter;
        Iterable<Edge> eachEdge;

        public ConnectedComponent(Integer id) {
            this.id = id;
            this.nodeFilter = null;
            this.edgeFilter = null;
            this.eachEdge = null;
        }

        @Override
        public Iterator<Node> iterator() {
            if (this.nodeFilter == null) {
                this.nodeFilter = Filters.byAttributeFilter((String)ConnectedComponents.this.countAttribute, (Object)this.id);
            }
            return new FilteredNodeIterator(ConnectedComponents.this.graph, this.nodeFilter);
        }

        public Iterable<Node> getEachNode() {
            return this;
        }

        public Iterable<Edge> getEachEdge() {
            if (this.eachEdge == null) {
                this.eachEdge = new Iterable<Edge>(){

                    @Override
                    public Iterator<Edge> iterator() {
                        return ConnectedComponent.this.getEdgeIterator();
                    }
                };
            }
            return this.eachEdge;
        }

        public Iterator<Edge> getEdgeIterator() {
            if (this.edgeFilter == null) {
                if (this.nodeFilter == null) {
                    this.nodeFilter = Filters.byAttributeFilter((String)ConnectedComponents.this.countAttribute, (Object)this.id);
                }
                this.edgeFilter = new EdgeFilter(this.nodeFilter);
            }
            return new FilteredEdgeIterator(ConnectedComponents.this.graph, this.edgeFilter);
        }
    }
}

