/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.randomWalk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.randomWalk.Entity;
import org.graphstream.algorithm.randomWalk.RandomWalk;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class TabuEntity
extends Entity {
    protected LinkedList<Node> memory;
    protected double[] weights;

    @Override
    public void init(RandomWalk.Context context, Node start) {
        super.init(context, start);
        if (this.memory != null) {
            this.memory.clear();
        }
    }

    @Override
    public void step() {
        this.tabuStep();
    }

    protected void tabuStep() {
        int n = this.current.getOutDegree();
        Iterator to = this.current.getLeavingEdgeIterator();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        while (to.hasNext()) {
            Edge e = (Edge)to.next();
            if (this.tabu(e.getOpposite(this.current))) continue;
            edges.add(e);
        }
        n = edges.size();
        if (n == 0) {
            this.jump();
        } else if (this.context.weightAttribute != null) {
            int i;
            if (this.weights == null || n > this.weights.length) {
                this.weights = new double[n];
            }
            double sum = 0.0;
            for (i = 0; i < n; ++i) {
                this.weights[i] = this.weight((Edge)edges.get(i));
                sum += this.weights[i];
            }
            i = 0;
            while (i < n) {
                int n2 = i++;
                this.weights[n2] = this.weights[n2] / sum;
            }
            double r = this.context.random.nextDouble();
            double s = 0.0;
            for (int i2 = 0; i2 < n; ++i2) {
                if (!(r < (s += this.weights[i2]))) continue;
                this.cross((Edge)edges.get(i2));
                i2 = n;
            }
        } else {
            this.cross((Edge)edges.get(this.context.random.nextInt(n)));
        }
    }

    protected void jump() {
        this.current = Toolkit.randomNode(this.context.graph, this.context.random);
        ++this.context.jumpCount;
    }

    protected void cross(Edge e) {
        this.current = e.getOpposite(this.current);
        this.addPass(e, this.current);
        this.addToTabu(this.current);
    }

    protected void addPass(Edge e, Node n) {
        e.setAttribute(this.context.passesAttribute, new Object[]{e.getNumber(this.context.passesAttribute) + 1.0});
        n.setAttribute(this.context.passesAttribute, new Object[]{n.getNumber(this.context.passesAttribute) + 1.0});
    }

    protected void addToTabu(Node node) {
        if (this.context.entityMemory > 0) {
            this.memory.addFirst(node);
            if (this.memory.size() > this.context.entityMemory) {
                this.memory.removeLast();
            }
        }
    }

    protected boolean tabu(Node node) {
        if (node.hasAttribute("tabu")) {
            return true;
        }
        if (this.context.entityMemory > 0) {
            if (this.memory == null) {
                this.memory = new LinkedList();
            }
            int n = this.memory.size();
            for (int i = 0; i < n; ++i) {
                if (node != this.memory.get(i)) continue;
                return true;
            }
        }
        return false;
    }
}

