/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class AttributeCondition {
    public final String conditionText;
    public final Set<String> parameters;
    final ScriptEngine scriptEngine;

    public AttributeCondition(String condition, Collection<String> conditionParameters, ScriptEngine engine) {
        this.conditionText = condition;
        this.parameters = new HashSet<String>(conditionParameters);
        this.scriptEngine = engine;
    }

    public boolean eval() {
        if (this.parameters.isEmpty()) {
            try {
                return (Boolean)this.scriptEngine.eval(this.conditionText);
            }
            catch (ScriptException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Warning: Attribute condition did not return a boolean value");
            }
        }
        return true;
    }
}

