/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;

public class AttributeConstraint
implements UnaryConstraint {
    final EAttribute attribute;
    final Object value;
    final boolean isConstantValue;

    public AttributeConstraint(EAttribute attribute, Object value, boolean isConstantValue) {
        this.attribute = attribute;
        this.value = value;
        this.isConstantValue = isConstantValue;
    }

    @Override
    public boolean check(DomainSlot slot) {
        if (this.isConstantValue) {
            if (slot.locked) {
                Object attValue = slot.value.eGet((EStructuralFeature)this.attribute);
                return this.value == null ? attValue == null : attValue != null && attValue.equals(this.value);
            }
            int size = slot.domain.size();
            for (int i = size - 1; i >= 0; --i) {
                EObject domainObject = slot.domain.get(i);
                if (this.value == null) {
                    if (domainObject.eGet((EStructuralFeature)this.attribute) == null) continue;
                    slot.domain.remove(i);
                    continue;
                }
                if (this.value.equals(domainObject.eGet((EStructuralFeature)this.attribute))) continue;
                slot.domain.remove(i);
            }
            return !slot.domain.isEmpty();
        }
        if (!slot.locked) {
            return true;
        }
        Object attValue = slot.value.eGet((EStructuralFeature)this.attribute);
        String paramName = (String)this.value;
        if (!slot.conditionHandler.isSet(paramName)) {
            boolean ok = slot.conditionHandler.setParameter(paramName, attValue);
            if (!ok) {
                slot.conditionHandler.unsetParameter(paramName);
            }
            return ok;
        }
        Object paramValue = slot.conditionHandler.getParameter(paramName);
        return paramValue == null ? attValue == null : paramValue.equals(attValue);
    }
}

