/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.PathConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class DomainSlot {
    Variable owner;
    boolean initialized = false;
    boolean locked = false;
    EObject value;
    List<EObject> domain;
    List<EObject> temporaryDomain;
    final Map<BinaryConstraint, DomainChange> remoteChangeMap;
    final List<String> initializedParameters;
    final ConditionHandler conditionHandler;
    final Set<Variable> checkedVariables;
    final Set<EObject> usedObjects;
    final boolean injective;
    final boolean dangling;
    final boolean deterministic;
    final boolean inverseMatchingOrder;

    public DomainSlot(ConditionHandler conditionHandler, Set<EObject> usedObjects, boolean injective, boolean dangling, boolean deterministic, boolean inverseMatchingOrder) {
        this.conditionHandler = conditionHandler;
        this.usedObjects = usedObjects;
        this.remoteChangeMap = new HashMap<BinaryConstraint, DomainChange>();
        this.initializedParameters = new ArrayList<String>();
        this.checkedVariables = new HashSet<Variable>();
        this.injective = injective;
        this.dangling = dangling;
        this.deterministic = deterministic;
        this.inverseMatchingOrder = inverseMatchingOrder;
    }

    public boolean instantiate(Variable variable, Map<Variable, DomainSlot> domainMap, EGraph graph) {
        if (!this.initialized) {
            this.initialized = true;
            this.owner = variable;
            if (this.temporaryDomain != null) {
                this.domain = new ArrayList<EObject>(this.temporaryDomain);
            }
            variable.typeConstraint.initDomain(this, graph);
            if (this.domain.isEmpty()) {
                return false;
            }
            if (!this.deterministic) {
                Collections.shuffle(this.domain);
            }
            if (this.injective) {
                this.domain.removeAll(this.usedObjects);
            }
        }
        if (!this.locked) {
            if (this.domain.isEmpty()) {
                return false;
            }
            this.value = this.inverseMatchingOrder ? this.domain.remove(this.domain.size() - 1) : this.domain.remove(0);
            this.usedObjects.add(this.value);
            this.locked = true;
        }
        if (!this.checkedVariables.contains(variable)) {
            DomainSlot targetSlot;
            if (!variable.typeConstraint.check(this)) {
                return false;
            }
            if (this.dangling) {
                for (DanglingConstraint danglingConstraint : variable.danglingConstraints) {
                    if (danglingConstraint.check(this.value, graph)) continue;
                    return false;
                }
            }
            for (AttributeConstraint attributeConstraint : variable.attributeConstraints) {
                if (!attributeConstraint.isConstantValue && !this.conditionHandler.isSet((String)attributeConstraint.value)) {
                    this.initializedParameters.add((String)attributeConstraint.value);
                }
                if (!attributeConstraint.check(this)) {
                    return false;
                }
                UnaryConstraint unaryUserConstraint = variable.attributeUserConstraints.get(attributeConstraint);
                if (unaryUserConstraint == null || unaryUserConstraint.check(this)) continue;
                return false;
            }
            for (ContainmentConstraint containmentConstraint : variable.containmentConstraints) {
                if (containmentConstraint.check(this, targetSlot = domainMap.get(containmentConstraint.targetVariable))) continue;
                return false;
            }
            for (ReferenceConstraint referenceConstraint : variable.referenceConstraints) {
                if (!referenceConstraint.check(this, targetSlot = domainMap.get(referenceConstraint.targetVariable))) {
                    return false;
                }
                BinaryConstraint binaryUserConstraint = variable.binaryUserConstraints.get(referenceConstraint);
                if (binaryUserConstraint == null || binaryUserConstraint.check(this, targetSlot)) continue;
                return false;
            }
            for (PathConstraint pathConstraint : variable.pathConstraints) {
                if (pathConstraint.check(this, targetSlot = domainMap.get(pathConstraint.targetVariable))) continue;
                return false;
            }
            for (UnaryConstraint unaryConstraint : variable.userConstraints) {
                if (unaryConstraint.check(this)) continue;
                return false;
            }
            this.checkedVariables.add(variable);
        }
        return true;
    }

    public boolean unlock(Variable sender) {
        int refCount = sender.referenceConstraints.size();
        int conCount = sender.containmentConstraints.size();
        for (int i = refCount + conCount - 1; i >= 0; --i) {
            BinaryConstraint constraint = i >= refCount ? (BinaryConstraint)sender.containmentConstraints.get(i - refCount) : (BinaryConstraint)sender.referenceConstraints.get(i);
            DomainChange change = this.remoteChangeMap.get(constraint);
            if (change == null) continue;
            change.slot.temporaryDomain = change.originalValues;
            this.remoteChangeMap.remove(constraint);
        }
        if (this.locked && sender == this.owner) {
            this.locked = false;
            this.usedObjects.remove(this.value);
            for (String parameterName : this.initializedParameters) {
                this.conditionHandler.unsetParameter(parameterName);
            }
            this.initializedParameters.clear();
            this.checkedVariables.clear();
            return this.domain != null && !this.domain.isEmpty();
        }
        this.checkedVariables.remove(sender);
        return false;
    }

    public void clear(Variable sender) {
        this.unlock(sender);
        if (sender == this.owner) {
            this.initialized = false;
            this.remoteChangeMap.clear();
            this.owner = null;
            this.value = null;
            this.domain = null;
        }
    }

    public void reset(Variable sender) {
        if (sender == this.owner) {
            this.temporaryDomain = null;
        }
        this.clear(sender);
    }

    public boolean recheck(Variable variable, Map<Variable, DomainSlot> domainMap) {
        this.checkedVariables.remove(variable);
        return this.instantiate(variable, domainMap, null);
    }

    public boolean instantiationPossible() {
        if (this.domain == null) {
            return false;
        }
        if (!this.locked) {
            return this.domain.size() > 0;
        }
        return false;
    }

    public void fixInstantiation(EObject value) {
        this.locked = true;
        this.value = value;
        this.initialized = true;
        this.usedObjects.add(value);
        this.owner = null;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public EObject getValue() {
        return this.value;
    }

    public List<EObject> getDomain() {
        return this.domain;
    }

    public void setTemporaryDomain(List<EObject> temporaryDomain) {
        this.temporaryDomain = temporaryDomain;
    }

    public List<EObject> getTemporaryDomain() {
        return this.temporaryDomain;
    }

    public Map<BinaryConstraint, DomainChange> getRemoteChangeMap() {
        return this.remoteChangeMap;
    }
}

