/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class PathConstraint
implements BinaryConstraint {
    static final Integer[] INTEGERS = new Integer[64];
    final Variable targetVariable;
    final List<EReference> references;
    final int numPaths;

    public PathConstraint(Variable target, List<EReference> references, int numPaths) {
        this.targetVariable = target;
        this.references = references;
        this.numPaths = numPaths;
        if (references.isEmpty()) {
            throw new IllegalArgumentException("Cannot create path constraint for empty paths");
        }
    }

    private static Integer inc(Integer integer) {
        if (integer == null) {
            return INTEGERS[1];
        }
        int succ = integer + 1;
        if (succ < INTEGERS.length) {
            return INTEGERS[succ];
        }
        return succ;
    }

    private static Map<EObject, Integer> getTargetObjects(Map<EObject, Integer> sources, EReference reference) {
        LinkedHashMap<EObject, Integer> targets = new LinkedHashMap<EObject, Integer>();
        for (Map.Entry<EObject, Integer> source : sources.entrySet()) {
            EObject src = source.getKey();
            if (!src.eClass().getEAllReferences().contains((Object)reference)) continue;
            if (reference.isMany()) {
                for (EObject trg : (List)src.eGet((EStructuralFeature)reference)) {
                    targets.put(trg, PathConstraint.inc((Integer)targets.get(trg)));
                }
                continue;
            }
            EObject trg = (EObject)src.eGet((EStructuralFeature)reference);
            if (trg == null) continue;
            targets.put(trg, PathConstraint.inc((Integer)targets.get(trg)));
        }
        return targets;
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        if (!source.locked) {
            return false;
        }
        Map<EObject, Integer> targetObjects = new HashMap<EObject, Integer>();
        targetObjects.put(source.value, INTEGERS[1]);
        for (EReference reference : this.references) {
            targetObjects = PathConstraint.getTargetObjects(targetObjects, reference);
        }
        if (target.locked) {
            Integer numTargets = (Integer)targetObjects.get(target.value);
            return numTargets != null && numTargets >= this.numPaths;
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        target.temporaryDomain = new ArrayList<EObject>();
        for (Map.Entry<EObject, Integer> entry : targetObjects.entrySet()) {
            if (entry.getValue() < this.numPaths) continue;
            target.temporaryDomain.add(entry.getKey());
        }
        return !target.temporaryDomain.isEmpty();
    }

    static {
        for (int i = 0; i < INTEGERS.length; ++i) {
            PathConstraint.INTEGERS[i] = i;
        }
    }
}

