/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.staticanalysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;

public class NodeMap
extends LinkedHashMap<Node, Node> {
    private static final long serialVersionUID = 1L;
    private final Graph source;
    private final Graph target;

    public NodeMap(Graph source, Graph target) {
        this.source = source;
        this.target = target;
    }

    public boolean isTotal() {
        return this.source.getNodes().size() == this.keySet().size() && this.keySet().containsAll((Collection<?>)this.source.getNodes());
    }

    public boolean isInjective() {
        HashSet images = new HashSet();
        for (Node origin : this.keySet()) {
            if (images.add(this.get(origin))) continue;
            return false;
        }
        return true;
    }

    public boolean isSurjective() {
        return this.target.getNodes().size() == this.values().size() && this.values().containsAll((Collection<?>)this.target.getNodes());
    }

    public boolean isBijective() {
        return this.isTotal() && this.isInjective() && this.isSurjective();
    }

    public boolean isGraphMorphism() {
        for (Node origin : this.keySet()) {
            if (origin.getType() == ((Node)this.get(origin)).getType()) continue;
            return false;
        }
        for (Edge edge : this.source.getEdges()) {
            Node srcImage = (Node)this.get(edge.getSource());
            Node trgImage = (Node)this.get(edge.getTarget());
            if (srcImage == null || trgImage == null || srcImage.getOutgoing(edge.getType(), trgImage) != null) continue;
            return false;
        }
        return true;
    }

    public NodeMap getInverse() throws Exception {
        if (!this.isInjective()) {
            throw new RuntimeException("Cannot invert non-injective graph morphism");
        }
        NodeMap inverse = new NodeMap(this.target, this.source);
        for (Node origin : this.keySet()) {
            inverse.put(this.get(origin), origin);
        }
        return inverse;
    }
}

