/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashSet;
import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class Eccentricity
implements Algorithm {
    protected Graph graph;
    protected String apspInfoAttribute = "APSPInfo";
    protected String eccentricityAttribute = "eccentricity";
    protected Object isInEccentricity = Boolean.TRUE;
    protected Object isNotInEccentricity = Boolean.FALSE;

    public Eccentricity() {
        this("eccentricity");
    }

    public Eccentricity(String eccentricityAttribute) {
        this(eccentricityAttribute, Boolean.TRUE, Boolean.FALSE);
    }

    public Eccentricity(String eccentricityAttribute, Object isInEccentricity, Object isNotInEccentricity) {
        this(eccentricityAttribute, Boolean.TRUE, Boolean.FALSE, "APSPInfo");
    }

    public Eccentricity(String eccentricityAttribute, Object isInEccentricity, Object isNotInEccentricity, String apspInfoAttribute) {
        this.eccentricityAttribute = eccentricityAttribute;
        this.isInEccentricity = isInEccentricity;
        this.isNotInEccentricity = isNotInEccentricity;
        this.apspInfoAttribute = apspInfoAttribute;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        double min = Double.MAX_VALUE;
        HashSet<Node> eccentricity = new HashSet<Node>();
        for (Node node : this.graph.getEachNode()) {
            double m = Double.MIN_VALUE;
            APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute(this.apspInfoAttribute);
            if (info == null) {
                System.err.printf("APSPInfo missing. Did you compute APSP before ?\n", new Object[0]);
            }
            for (Node other : this.graph.getEachNode()) {
                if (node == other) continue;
                double d = info.getLengthTo(other.getId());
                if (d < 0.0) {
                    System.err.printf("Found a negative length value in eccentricity algorithm. Is graph connected ?\n", new Object[0]);
                    continue;
                }
                if (!(d > m)) continue;
                m = d;
            }
            if (m < min) {
                eccentricity.clear();
                eccentricity.add(node);
                min = m;
                continue;
            }
            if (m != min) continue;
            eccentricity.add(node);
        }
        for (Node node : this.graph.getEachNode()) {
            node.setAttribute(this.eccentricityAttribute, new Object[]{eccentricity.contains(node) ? this.isInEccentricity : this.isNotInEccentricity});
        }
        eccentricity.clear();
    }

    public String getAPSPInfoAttribute() {
        return this.apspInfoAttribute;
    }

    public void setAPSPInfoAttribute(String attribute) {
        this.apspInfoAttribute = attribute;
    }

    public Object getIsInEccentricityValue() {
        return this.isInEccentricity;
    }

    public void setIsInEccentricityValue(Object value) {
        this.isInEccentricity = value;
    }

    public Object getIsNotInEccentricityValue() {
        return this.isNotInEccentricity;
    }

    public void setIsNotInEccentricityValue(Object value) {
        this.isNotInEccentricity = value;
    }

    public String getEccentricityAttribute() {
        return this.eccentricityAttribute;
    }

    public void setEccentricityAttribute(String eccentricityAttribute) {
        this.eccentricityAttribute = eccentricityAttribute;
    }
}

