/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomTools {
    public static double exponential(Random rnd) {
        double y;
        int k;
        int z = -1;
        do {
            double u;
            double w = y = rnd.nextDouble();
            k = 1;
            while (!((u = rnd.nextDouble()) > w)) {
                w = u;
                ++k;
            }
            ++z;
        } while ((k & 1) == 0);
        return (double)z + y;
    }

    public static int binomial(int n, double p, Random rnd) {
        double q = -Math.log(1.0 - p);
        int x = 0;
        double s = 0.0;
        do {
        } while ((s += RandomTools.exponential(rnd) / (double)(n - ++x)) <= q);
        return x - 1;
    }

    public static Set<Integer> randomKsubset(int n, int k, Set<Integer> subset, Random rnd) {
        if (subset == null) {
            subset = new HashSet<Integer>(4 * k / 3 + 1);
        } else {
            subset.clear();
        }
        for (int i = n - k; i < n; ++i) {
            int j = rnd.nextInt(i + 1);
            subset.add(subset.contains(j) ? i : j);
        }
        return subset;
    }

    public static Set<Integer> randomPsubset(int n, double p, Set<Integer> subset, Random rnd) {
        return RandomTools.randomKsubset(n, RandomTools.binomial(n, p, rnd), subset, rnd);
    }
}

