/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BoundedContextType implements Enumerator
{
    FEATURE(0, "FEATURE", "FEATURE"),
    APPLICATION(1, "APPLICATION", "APPLICATION"),
    SYSTEM(2, "SYSTEM", "SYSTEM"),
    TEAM(3, "TEAM", "TEAM");

    public static final int FEATURE_VALUE = 0;
    public static final int APPLICATION_VALUE = 1;
    public static final int SYSTEM_VALUE = 2;
    public static final int TEAM_VALUE = 3;
    private static final BoundedContextType[] VALUES_ARRAY;
    public static final List<BoundedContextType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BoundedContextType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BoundedContextType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BoundedContextType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BoundedContextType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BoundedContextType get(int value) {
        switch (value) {
            case 0: {
                return FEATURE;
            }
            case 1: {
                return APPLICATION;
            }
            case 2: {
                return SYSTEM;
            }
            case 3: {
                return TEAM;
            }
        }
        return null;
    }

    private BoundedContextType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BoundedContextType[]{FEATURE, APPLICATION, SYSTEM, TEAM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

