/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContextMapType implements Enumerator
{
    SYSTEM_LANDSCAPE(0, "SYSTEM_LANDSCAPE", "SYSTEM_LANDSCAPE"),
    ORGANIZATIONAL(1, "ORGANIZATIONAL", "ORGANIZATIONAL");

    public static final int SYSTEM_LANDSCAPE_VALUE = 0;
    public static final int ORGANIZATIONAL_VALUE = 1;
    private static final ContextMapType[] VALUES_ARRAY;
    public static final List<ContextMapType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ContextMapType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContextMapType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ContextMapType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContextMapType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ContextMapType get(int value) {
        switch (value) {
            case 0: {
                return SYSTEM_LANDSCAPE;
            }
            case 1: {
                return ORGANIZATIONAL;
            }
        }
        return null;
    }

    private ContextMapType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ContextMapType[]{SYSTEM_LANDSCAPE, ORGANIZATIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

