/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Import;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.services.ContextMappingDSLGrammarAccess;
import org.contextmapper.tactic.dsl.formatting2.TacticDDDLanguageFormatter;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObjectOperation;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ContextMappingDSLFormatter
extends TacticDDDLanguageFormatter {
    @Inject
    @Extension
    private ContextMappingDSLGrammarAccess _contextMappingDSLGrammarAccess;

    protected void _format(ContextMappingModel contextMappingModel, @Extension IFormattableDocument document) {
        boolean ignoredFirst = !Objects.equal((Object)contextMappingModel.getFirstLineComment(), null) && !"".equals(contextMappingModel.getFirstLineComment());
        EList<Import> _imports = contextMappingModel.getImports();
        for (Object cmlImport : _imports) {
            if (ignoredFirst) {
                Procedures.Procedure1 _function = it -> it.newLine();
                document.prepend((EObject)cmlImport, _function);
                continue;
            }
            ignoredFirst = true;
        }
        document.format((Object)contextMappingModel.getMap());
        EList<BoundedContext> _boundedContexts = contextMappingModel.getBoundedContexts();
        for (BoundedContext boundedContext : _boundedContexts) {
            document.format((Object)boundedContext);
        }
        EList<Domain> _domains = contextMappingModel.getDomains();
        for (Domain domain : _domains) {
            document.format((Object)domain);
            EList<Subdomain> _subdomains = domain.getSubdomains();
            for (Subdomain subdomain : _subdomains) {
                document.format((Object)subdomain);
            }
        }
    }

    protected void _format(ContextMap contextMap, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.setNewLines(2);
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(this.textRegionExtensions.regionFor((EObject)contextMap).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getOPENRule()), _function), document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)contextMap).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getCLOSERule()), _function_1), _function_2), _function_3);
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.setNewLines(1);
            document.prepend(it, _function_5);
        };
        this.textRegionExtensions.regionFor((EObject)contextMap).keywords(new String[]{"contains"}).forEach(_function_4);
        EList<Relationship> _relationships = contextMap.getRelationships();
        for (Relationship relationship : _relationships) {
            document.format((Object)relationship);
        }
    }

    protected void _format(BoundedContext boundedContext, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(this.textRegionExtensions.regionFor((EObject)boundedContext).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getOPENRule()), _function), document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getCLOSERule()), _function_1), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.setNewLines(2);
        document.prepend((EObject)boundedContext, _function_4);
        if (boundedContext.getComment() != null && !"".equals(boundedContext.getComment())) {
            Procedures.Procedure1 _function_5 = it -> it.newLine();
            document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("BoundedContext"), _function_5);
        }
        Procedures.Procedure1 _function_6 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("domainVisionStatement"), _function_6);
        Procedures.Procedure1 _function_7 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("type"), _function_7);
        Procedures.Procedure1 _function_8 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("responsibilities"), _function_8);
        Procedures.Procedure1 _function_9 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("implementationTechnology"), _function_9);
        Procedures.Procedure1 _function_10 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)boundedContext).keyword("knowledgeLevel"), _function_10);
        EList<Aggregate> _aggregates = boundedContext.getAggregates();
        for (Aggregate aggregate : _aggregates) {
            document.format((Object)aggregate);
        }
        EList<SculptorModule> _modules = boundedContext.getModules();
        for (SculptorModule module : _modules) {
            document.format((Object)module);
        }
    }

    protected void _format(Relationship relationship, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(this.textRegionExtensions.regionFor((EObject)relationship).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getOPENRule()), _function), document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)relationship).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getCLOSERule()), _function_1), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)relationship).keyword("implementationTechnology"), _function_4);
        Procedures.Procedure1 _function_5 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)relationship).keyword("exposedAggregates"), _function_5);
        Procedures.Procedure1 _function_6 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)relationship).keyword("downstreamRights"), _function_6);
        Procedures.Procedure1 _function_7 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("U"), _function_7);
        Procedures.Procedure1 _function_8 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("D"), _function_8);
        Procedures.Procedure1 _function_9 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("OHS"), _function_9);
        Procedures.Procedure1 _function_10 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("PL"), _function_10);
        Procedures.Procedure1 _function_11 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("ACL"), _function_11);
        Procedures.Procedure1 _function_12 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)relationship).keyword("CF"), _function_12);
        Consumer<ISemanticRegion> _function_13 = it -> {
            Procedures.Procedure1 _function_14 = it_1 -> it_1.noSpace();
            document.surround(it, _function_14);
        };
        this.textRegionExtensions.regionFor((EObject)relationship).keywords(new String[]{"SK"}).forEach(_function_13);
        Consumer<ISemanticRegion> _function_14 = it -> {
            Procedures.Procedure1 _function_15 = it_1 -> it_1.noSpace();
            document.surround(it, _function_15);
        };
        this.textRegionExtensions.regionFor((EObject)relationship).keywords(new String[]{"P"}).forEach(_function_14);
        Consumer<ISemanticRegion> _function_15 = it -> {
            Procedures.Procedure1 _function_16 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_16);
            Procedures.Procedure1 _function_17 = it_1 -> it_1.oneSpace();
            document.append(it, _function_17);
        };
        this.textRegionExtensions.regionFor((EObject)relationship).keywords(new String[]{","}).forEach(_function_15);
        Procedures.Procedure1 _function_16 = it -> it.setNewLines(2);
        document.prepend((EObject)relationship, _function_16);
    }

    protected void _format(Aggregate aggregate, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(this.textRegionExtensions.regionFor((EObject)aggregate).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getOPENRule()), _function), document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)aggregate).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getCLOSERule()), _function_1), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.setNewLines(1);
        document.prepend((EObject)aggregate, _function_4);
        Procedures.Procedure1 _function_5 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)aggregate).keyword("Aggregate"), _function_5);
        EList<SimpleDomainObject> _domainObjects = aggregate.getDomainObjects();
        for (SimpleDomainObject domainObject : _domainObjects) {
            document.format((Object)domainObject);
        }
        EList<Service> _services = aggregate.getServices();
        for (Service service : _services) {
            document.format((Object)service);
        }
    }

    protected void _format(SculptorModule module, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(this.textRegionExtensions.regionFor((EObject)module).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getOPENRule()), _function), document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)module).ruleCallTo((AbstractRule)this._contextMappingDSLGrammarAccess.getCLOSERule()), _function_1), _function_2), _function_3);
        EList<Aggregate> _aggregates = module.getAggregates();
        for (Aggregate aggregate : _aggregates) {
            document.format((Object)aggregate);
        }
    }

    @Override
    public void format(Object aggregate, IFormattableDocument document) {
        if (aggregate instanceof CommandEvent) {
            this._format((CommandEvent)aggregate, document);
            return;
        }
        if (aggregate instanceof DomainEvent) {
            this._format((DomainEvent)aggregate, document);
            return;
        }
        if (aggregate instanceof Attribute) {
            this._format((Attribute)aggregate, document);
            return;
        }
        if (aggregate instanceof Entity) {
            this._format((Entity)aggregate, document);
            return;
        }
        if (aggregate instanceof Reference) {
            this._format((Reference)aggregate, document);
            return;
        }
        if (aggregate instanceof ValueObject) {
            this._format((ValueObject)aggregate, document);
            return;
        }
        if (aggregate instanceof XtextResource) {
            this._format((XtextResource)aggregate, document);
            return;
        }
        if (aggregate instanceof DomainObjectOperation) {
            this._format((DomainObjectOperation)aggregate, document);
            return;
        }
        if (aggregate instanceof Parameter) {
            this._format((Parameter)aggregate, document);
            return;
        }
        if (aggregate instanceof Aggregate) {
            this._format((Aggregate)aggregate, document);
            return;
        }
        if (aggregate instanceof BoundedContext) {
            this._format((BoundedContext)aggregate, document);
            return;
        }
        if (aggregate instanceof ContextMap) {
            this._format((ContextMap)aggregate, document);
            return;
        }
        if (aggregate instanceof ContextMappingModel) {
            this._format((ContextMappingModel)aggregate, document);
            return;
        }
        if (aggregate instanceof Relationship) {
            this._format((Relationship)aggregate, document);
            return;
        }
        if (aggregate instanceof SculptorModule) {
            this._format((SculptorModule)aggregate, document);
            return;
        }
        if (aggregate instanceof ComplexType) {
            this._format((ComplexType)aggregate, document);
            return;
        }
        if (aggregate instanceof EObject) {
            this._format((EObject)aggregate, document);
            return;
        }
        if (aggregate == null) {
            this._format(null, document);
            return;
        }
        if (aggregate != null) {
            this._format(aggregate, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(aggregate, document).toString());
    }
}

