/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import ch.hsr.servicecutter.api.ServiceCutter;
import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.ServiceCutterContextBuilder;
import ch.hsr.servicecutter.api.model.EntityRelationDiagram;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.api.model.UserRepresentationContainer;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.generator.AbstractContextMapGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.exception.NoContextMapDefinedException;
import org.contextmapper.dsl.generator.servicecutter.input.converter.ContextMappingModelToServiceCutterERDConverter;
import org.contextmapper.dsl.generator.servicecutter.output.converter.ServiceCutterOutputToContextMappingModelConverter;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class NewServiceCutContextMapGenerator
extends AbstractContextMapGenerator {
    private SolverConfiguration solverConfiguration;
    private UserRepresentationContainer userRepresentationContainer;

    public NewServiceCutContextMapGenerator setSolverConfiguration(SolverConfiguration solverConfiguration) {
        this.solverConfiguration = solverConfiguration;
        return this;
    }

    public NewServiceCutContextMapGenerator setUserRepresentationContainer(UserRepresentationContainer userRepresentationContainer) {
        this.userRepresentationContainer = userRepresentationContainer;
        return this;
    }

    @Override
    protected void generateFromContextMap(ContextMap contextMap, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.checkPreconditions(this.contextMappingModel);
        String fileBaseName = inputFileURI.trimFileExtension().lastSegment();
        EntityRelationDiagram erdInput = new ContextMappingModelToServiceCutterERDConverter().convert(fileBaseName, contextMap);
        ServiceCutterContextBuilder contextBuilder = new ServiceCutterContextBuilder(erdInput);
        if (this.solverConfiguration != null) {
            contextBuilder.withCustomSolverConfiguration(this.solverConfiguration);
        }
        if (this.userRepresentationContainer != null) {
            contextBuilder.withUserRepresentations(this.userRepresentationContainer);
        }
        ServiceCutterContext context = contextBuilder.build();
        SolverResult result = new ServiceCutter(context).generateDecomposition();
        ContextMappingModel newServiceCutModel = new ServiceCutterOutputToContextMappingModelConverter().convert(result);
        int counter = 1;
        String fileName = inputFileURI.trimFileExtension().lastSegment() + "_NewCut_" + counter + ".cml";
        if (fsa.isFile(fileName)) {
            while (fsa.isFile(fileName)) {
                fileName = inputFileURI.trimFileExtension().lastSegment() + "_NewCut_" + ++counter + ".cml";
            }
        }
        Resource resource = this.resourceSet.createResource(URI.createURI((String)fileName));
        resource.getContents().add((Object)newServiceCutModel);
        try (ByteArrayOutputStream outputstream = new ByteArrayOutputStream();){
            resource.save((OutputStream)outputstream, null);
            try (ByteArrayInputStream inputstream = new ByteArrayInputStream(outputstream.toByteArray());){
                fsa.generateFile(fileName, (InputStream)inputstream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Saving CML model was not possible.", e);
        }
    }

    public void checkPreconditions(ContextMappingModel model) {
        if (model.getMap() == null) {
            throw new NoContextMapDefinedException();
        }
        if (this.collectAttributes(model).isEmpty()) {
            throw new GeneratorInputException("Your model should at least contain one Bounded Context with entities and some attributes. Without attributes (Service Cutter nanoentities) we cannot calculate service cuts.");
        }
    }

    private List<Attribute> collectAttributes(ContextMappingModel model) {
        ArrayList attributes = Lists.newArrayList();
        for (BoundedContext bc : model.getMap().getBoundedContexts()) {
            attributes.addAll(EcoreUtil2.getAllContentsOfType((EObject)bc, Attribute.class));
        }
        return attributes;
    }
}

