/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.generator.AbstractContextMapGenerator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLBoundedContextClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLComponentDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLSubdomainClassDiagramCreator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class PlantUMLGenerator
extends AbstractContextMapGenerator {
    private static final String PLANT_UML_FILE_EXT = "puml";

    @Override
    protected void generateFromContextMap(ContextMap contextMap, IFileSystemAccess2 fsa, URI inputFileURI) {
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        fsa.generateFile(fileName + "_ContextMap." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLComponentDiagramCreator().createDiagram(contextMap));
        for (BoundedContext boundedContext : contextMap.getBoundedContexts()) {
            fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLBoundedContextClassDiagramCreator().createDiagram(boundedContext));
        }
        for (Domain domain : this.contextMappingModel.getDomains()) {
            domain.getSubdomains().stream().filter(subdomain -> subdomain.getEntities().size() > 0).forEach(subdomain -> fsa.generateFile(fileName + "_SD_" + subdomain.getName() + "." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLSubdomainClassDiagramCreator(domain.getName()).createDiagram(subdomain)));
        }
    }
}

