/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Characteristic;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Compatibilities;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.RelatedGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ServiceCutterUserRepresentationsJSONGenerator
extends AbstractGenerator {
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        List configModels = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)resource.getAllContents(), ServiceCutterUserRepresentationsModel.class));
        if (configModels.size() > 0) {
            ServiceCutterUserRepresentationsModel model = (ServiceCutterUserRepresentationsModel)configModels.get(0);
            String modelName = resource.getURI().trimFileExtension().lastSegment();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.addMixIn(UseCase.class, DocMixIn.class);
            objectMapper.addMixIn(Compatibilities.class, DocMixIn.class);
            objectMapper.addMixIn(Characteristic.class, DocMixIn.class);
            objectMapper.addMixIn(RelatedGroup.class, DocMixIn.class);
            SimpleBeanPropertyFilter docFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"doc", "characteristicDoc"});
            SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("docFilter", docFilter);
            try {
                fsa.generateFile(modelName + ".json", (CharSequence)objectMapper.writer((FilterProvider)filters).writeValueAsString((Object)model));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("JSON conversion error occured!", e);
            }
        }
    }

    @JsonFilter(value="docFilter")
    class DocMixIn {
        DocMixIn() {
        }
    }
}

