/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.CustomerSupplierRelationship;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Partnership;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.freemarker.BoundedContextsFilterMethod;
import org.contextmapper.dsl.generator.freemarker.GetTypeOfComplexTypeMethod;
import org.contextmapper.dsl.generator.freemarker.InstanceOfMethod;
import org.contextmapper.dsl.generator.freemarker.TeamsFilterMethod;
import org.contextmapper.tactic.dsl.tacticdsl.BasicType;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DataTransferObject;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.Event;
import org.contextmapper.tactic.dsl.tacticdsl.Trait;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;

public class FreemarkerTextGenerator {
    private File templateFile;
    private Map<String, Object> dataMap;

    public FreemarkerTextGenerator(File templateFile) {
        this.templateFile = templateFile;
        this.dataMap = new HashMap<String, Object>();
    }

    public String generate(ContextMappingModel contextMappingModel) {
        String result = "";
        try {
            Configuration configuration = this.configureFreemarker();
            Template template = configuration.getTemplate(this.templateFile.getName());
            StringWriter writer = new StringWriter();
            template.process(this.prepareModelData(contextMappingModel), (Writer)writer);
            result = writer.toString();
        }
        catch (Exception e) {
            throw new ContextMapperApplicationException("Freemarker template exception: " + e.getMessage(), e);
        }
        return result;
    }

    public void registerCustomModelProperty(String propertyName, Object object) {
        this.dataMap.put(propertyName, object);
    }

    private Map<String, Object> prepareModelData(ContextMappingModel contextMappingModel) {
        this.dataMap.put("contextMap", contextMappingModel.getMap());
        this.dataMap.put("boundedContexts", contextMappingModel.getBoundedContexts());
        this.dataMap.put("domains", contextMappingModel.getDomains());
        this.dataMap.put("imports", contextMappingModel.getImports());
        this.dataMap.put("useCases", contextMappingModel.getUseCases());
        this.dataMap.put("timestamp", new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()));
        this.dataMap.put("filename", contextMappingModel.eResource().getURI().lastSegment().toString());
        this.dataMap.put("username", System.getProperty("user.name"));
        this.dataMap.putAll(this.createTemplatingHelperMethods());
        this.dataMap.putAll(this.createClassMap());
        return this.dataMap;
    }

    private Map<String, Object> createTemplatingHelperMethods() {
        HashMap<String, Object> methodsMap = new HashMap<String, Object>();
        methodsMap.put("instanceOf", new InstanceOfMethod());
        methodsMap.put("getType", new GetTypeOfComplexTypeMethod());
        methodsMap.put("filterBoundedContexts", new BoundedContextsFilterMethod());
        methodsMap.put("filterTeams", new TeamsFilterMethod());
        return methodsMap;
    }

    private Map<String, Object> createClassMap() {
        HashMap<String, Object> classMap = new HashMap<String, Object>();
        classMap.put("SymmetricRelationship", SymmetricRelationship.class);
        classMap.put("Partnership", Partnership.class);
        classMap.put("SharedKernel", SharedKernel.class);
        classMap.put("UpstreamDownstreamRelationship", UpstreamDownstreamRelationship.class);
        classMap.put("CustomerSupplierRelationship", CustomerSupplierRelationship.class);
        classMap.put("Domain", Domain.class);
        classMap.put("Subdomain", Subdomain.class);
        classMap.put("BasicType", BasicType.class);
        classMap.put("DataTransferObject", DataTransferObject.class);
        classMap.put("DomainObject", DomainObject.class);
        classMap.put("Enum", Enum.class);
        classMap.put("Trait", Trait.class);
        classMap.put("Entity", Entity.class);
        classMap.put("Event", Event.class);
        classMap.put("CommandEvent", CommandEvent.class);
        classMap.put("DomainEvent", DomainEvent.class);
        classMap.put("ValueObject", ValueObject.class);
        return classMap;
    }

    private Configuration configureFreemarker() throws IOException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setDirectoryForTemplateLoading(this.templateFile.getParentFile());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return configuration;
    }
}

