/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.contextmapper.dsl.generator.mdsl.ProtectedRegionContext;
import org.contextmapper.dsl.generator.mdsl.model.DataType;
import org.contextmapper.dsl.generator.mdsl.model.EndpointClient;
import org.contextmapper.dsl.generator.mdsl.model.EndpointContract;
import org.contextmapper.dsl.generator.mdsl.model.EndpointProvider;
import org.contextmapper.dsl.generator.mdsl.model.ServiceSpecification;

public class MDSLAPIDescriptionCreator {
    private static final String TEMPLATE_NAME = "mdsl-api-description.ftl";
    private Configuration freemarkerConfig;
    private Template freemarkerTemplate;
    private ProtectedRegionContext protectedRegionContext;

    public MDSLAPIDescriptionCreator(ProtectedRegionContext protectedRegionContext) {
        this.protectedRegionContext = protectedRegionContext;
        this.loadFreemarkerTemplate();
    }

    public String createAPIDescriptionText(ServiceSpecification serviceSpecification, String inputFileName) {
        this.updateServiceSpecification4ProtectedRegions(serviceSpecification);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("serviceSpecification", serviceSpecification);
        root.put("timestampString", this.getTimestampString(inputFileName));
        StringWriter writer = new StringWriter();
        try {
            this.freemarkerTemplate.process(root, (Writer)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing freemarker template.", e);
        }
        return writer.toString();
    }

    protected String getTimestampString(String inputFileName) {
        return "Generated from DDD Context Map '" + inputFileName + "' at " + new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()) + ".";
    }

    private void loadFreemarkerTemplate() {
        URL url = MDSLAPIDescriptionCreator.class.getResource(TEMPLATE_NAME);
        File templateDir = new File(System.getProperty("java.io.tmpdir"), "context-mapper-freemarker-templates-" + this.getPID());
        if (!templateDir.exists()) {
            templateDir.mkdir();
        }
        try {
            FileUtils.copyURLToFile((URL)url, (File)new File(templateDir, TEMPLATE_NAME));
            this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_22);
            this.freemarkerConfig.setDirectoryForTemplateLoading(templateDir);
            this.freemarkerConfig.setDefaultEncoding("UTF-8");
            this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.freemarkerTemplate = this.freemarkerConfig.getTemplate(TEMPLATE_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load freemarker template!", e);
        }
    }

    private long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    private void updateServiceSpecification4ProtectedRegions(ServiceSpecification serviceSpecification) {
        serviceSpecification.setDataTypeProtectedRegion(this.protectedRegionContext.getProtectedDataTypeRegion());
        serviceSpecification.setEndpointProtectedRegion(this.protectedRegionContext.getProtectedEndpointRegion());
        serviceSpecification.setProviderProtectedRegion(this.protectedRegionContext.getProtectedProviderRegion());
        serviceSpecification.setClientProtectedRegion(this.protectedRegionContext.getProtectedClientRegion());
        for (String protectedDataTye : this.protectedRegionContext.getDataTypeIdentifiers()) {
            Optional<DataType> dataType = serviceSpecification.getDataTypes().stream().filter(dt -> dt.getName().equals(protectedDataTye)).findAny();
            if (!dataType.isPresent()) continue;
            serviceSpecification.getDataTypes().remove(dataType.get());
        }
        for (String protectedEndpoint : this.protectedRegionContext.getEndpointIdentifiers()) {
            Optional<EndpointContract> endpoint = serviceSpecification.getEndpoints().stream().filter(ec -> ec.getName().equals(protectedEndpoint)).findAny();
            if (!endpoint.isPresent()) continue;
            serviceSpecification.getEndpoints().remove(endpoint.get());
        }
        for (String protectedProvider : this.protectedRegionContext.getProviderIdentifiers()) {
            Optional<EndpointProvider> provider = serviceSpecification.getProviders().stream().filter(p -> p.getName().equals(protectedProvider)).findAny();
            if (!provider.isPresent()) continue;
            serviceSpecification.getProviders().remove(provider.get());
        }
        for (String protectedClient : this.protectedRegionContext.getClientIdentifiers()) {
            Optional<EndpointClient> client = serviceSpecification.getClients().stream().filter(cl -> cl.getName().equals(protectedClient)).findAny();
            if (!client.isPresent()) continue;
            serviceSpecification.getClients().remove(client.get());
        }
    }
}

