/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.contextmapper.dsl.generator.mdsl.ProtectedRegionIdentifier;

public class ProtectedRegionReader {
    public String getProtectedRegionContent(String mdslInput, ProtectedRegionIdentifier regionIdentifier) {
        String regionStartString = this.getRegionStartString(regionIdentifier);
        if (this.containsProtectedRegion(mdslInput, regionIdentifier)) {
            return mdslInput.substring(mdslInput.indexOf(regionStartString) + regionStartString.length() + System.lineSeparator().length(), mdslInput.lastIndexOf(this.getRegionEndString(regionIdentifier)) - System.lineSeparator().length());
        }
        return null;
    }

    public boolean containsProtectedRegion(String mdslInput, ProtectedRegionIdentifier regionIdentifier) {
        String regionStartString = this.getRegionStartString(regionIdentifier);
        return mdslInput.indexOf(regionStartString) > -1;
    }

    public Set<String> getIdentifiersInProtectedRegion(String protectedRegion, ProtectedRegionIdentifier regionIdentifier) {
        HashSet ids = Sets.newHashSet();
        for (String line : protectedRegion.split("\\r?\\n")) {
            Pattern pattern = Pattern.compile("^[^\\/]?" + this.getIdentifierKeyWord(regionIdentifier) + " ([\\^]?[a-zA-Z_]{1}[a-zA-Z0-9_]*).*$");
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                ids.add(matcher.group(1));
            }
        }
        return ids;
    }

    private String getRegionStartString(ProtectedRegionIdentifier regionIdentifier) {
        return "// ** BEGIN PROTECTED REGION for " + regionIdentifier.toString();
    }

    private String getRegionEndString(ProtectedRegionIdentifier regionIdentifier) {
        return "// ** END PROTECTED REGION for " + regionIdentifier.toString();
    }

    private String getIdentifierKeyWord(ProtectedRegionIdentifier regionIdentifier) {
        switch (regionIdentifier) {
            case DATA_TYPE_REGION: {
                return "data type";
            }
            case ENDPOINT_REGION: {
                return "endpoint type";
            }
            case PROVIDER_REGION: {
                return "API provider";
            }
        }
        return "API client";
    }
}

