/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl.generatorcontext;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.contextmapper.dsl.generator.mdsl.generatorcontext.DownstreamContext;

public class UpstreamAPIContext {
    private String apiName;
    private BoundedContext upstreamContext;
    private List<UpstreamRole> upstreamRoles = Lists.newArrayList();
    private List<Aggregate> exposedAggregates = Lists.newArrayList();
    private List<String> implementationTechnologies = Lists.newArrayList();
    private Map<String, DownstreamContext> downstreamContexts = Maps.newHashMap();

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setUpstreamContext(BoundedContext upstreamContext) {
        this.upstreamContext = upstreamContext;
    }

    public BoundedContext getUpstreamContext() {
        return this.upstreamContext;
    }

    public List<UpstreamRole> getUpstreamRoles() {
        return this.upstreamRoles;
    }

    public List<Aggregate> getExposedAggregates() {
        return this.exposedAggregates;
    }

    public List<String> getImplementationTechnologies() {
        return this.implementationTechnologies;
    }

    public String getJoinedImplementationTechnologies() {
        return String.join((CharSequence)", ", new HashSet<String>(this.implementationTechnologies));
    }

    public void addDownstreamContext4Relationship(UpstreamDownstreamRelationship relationship) {
        String downStreamName = relationship.getDownstream().getName();
        if (!this.downstreamContexts.containsKey(downStreamName)) {
            this.downstreamContexts.put(downStreamName, new DownstreamContext(relationship.getDownstream()));
        }
        this.downstreamContexts.get(downStreamName).addConsumedAggregates((List<Aggregate>)relationship.getUpstreamExposedAggregates());
        this.downstreamContexts.get(downStreamName).addDownstreamRoles((List<DownstreamRole>)relationship.getDownstreamRoles());
    }

    public Collection<DownstreamContext> getDownstreamContexts() {
        return this.downstreamContexts.values();
    }
}

