/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl.model;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.generator.mdsl.model.DataTypeAttribute;

public class DataType {
    private String name;
    private boolean isAbstractType = true;
    private boolean isPrimitiveType = false;
    private boolean isEnumType = false;
    private List<DataTypeAttribute> attributes = Lists.newArrayList();
    private List<String> comments = Lists.newArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addAttributes(List<DataTypeAttribute> attributes) {
        this.isAbstractType = false;
        this.attributes.addAll(attributes);
    }

    public List<DataTypeAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isAbstractDataType() {
        return this.isAbstractType || this.attributes.isEmpty();
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType;
    }

    public void setIsPrimitiveType(boolean isPrimitiveType) {
        this.isPrimitiveType = isPrimitiveType;
    }

    public boolean hasComments() {
        return !this.comments.isEmpty();
    }

    public String getCommentsString() {
        return String.join((CharSequence)"; ", this.comments);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void setIsEnumType(boolean isEnumType) {
        this.isEnumType = isEnumType;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public String getEnumValuesString() {
        if (!this.isEnumType) {
            throw new RuntimeException("getEnumValuesString() called on datatype which is not an enum!");
        }
        return String.join((CharSequence)"|", this.attributes.stream().map(attr -> "\"" + attr.getName() + "\"").collect(Collectors.toList()));
    }
}

