/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.CustomerSupplierRelationship;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.Partnership;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;
import org.eclipse.emf.common.util.EList;

public class PlantUMLComponentDiagramCreator
extends AbstractPlantUMLDiagramCreator<ContextMap>
implements PlantUMLDiagramCreator<ContextMap> {
    private Set<String> interfaceNames = new HashSet<String>();
    private int interfaceCounter = 0;

    @Override
    protected void printDiagramContent(ContextMap contextMap) {
        if (contextMap.getBoundedContexts().size() <= 0) {
            this.printEmptyDiagramNote();
            return;
        }
        for (BoundedContext boundedContext : contextMap.getBoundedContexts()) {
            this.printComponent(boundedContext);
        }
        this.linebreak();
        for (Relationship relationship : contextMap.getRelationships()) {
            if (relationship instanceof Partnership) {
                this.printPartnershipRelationship((Partnership)relationship);
                continue;
            }
            if (relationship instanceof SharedKernel) {
                this.printSharedKernelRelationship((SharedKernel)relationship);
                continue;
            }
            if (!(relationship instanceof UpstreamDownstreamRelationship)) continue;
            this.printUpstreamDownstreamRelationship((UpstreamDownstreamRelationship)relationship);
        }
    }

    private void printEmptyDiagramNote() {
        this.sb.append("note").append(" ").append("\"").append("Sorry, we cannot generate a component diagram. Your Context Map seems to be empty.").append("\"").append(" as EmptyDiagramError");
        this.linebreak();
    }

    private void printPartnershipRelationship(Partnership relationship) {
        this.printSymmetricComponentRelationship(relationship.getParticipant1().getName(), relationship.getParticipant2().getName(), this.getRelationshipLabel(relationship));
        this.linebreak();
    }

    private void printSharedKernelRelationship(SharedKernel relationship) {
        this.printSymmetricComponentRelationship(relationship.getParticipant1().getName(), relationship.getParticipant2().getName(), this.getRelationshipLabel(relationship));
        this.linebreak();
    }

    private void printUpstreamDownstreamRelationship(UpstreamDownstreamRelationship relationship) {
        UpstreamDownstreamRelationship upDownRelationship = relationship;
        String interfaceId = this.getUniqueInterfaceId(upDownRelationship.getName(), upDownRelationship.getUpstream().getName(), upDownRelationship.getDownstream().getName());
        this.printInterface(this.getRelationshipLabel(relationship), interfaceId);
        if (upDownRelationship instanceof CustomerSupplierRelationship) {
            this.printCustomerSupplierInterfaceExposure(upDownRelationship.getUpstream().getName(), interfaceId, this.upstreamRolesToArray(upDownRelationship.getUpstreamRoles()));
        } else {
            this.printUpstreamDownstreamInterfaceExposure(upDownRelationship.getUpstream().getName(), interfaceId, this.upstreamRolesToArray(upDownRelationship.getUpstreamRoles()));
        }
        this.printInterfaceUsage(interfaceId, upDownRelationship);
        this.linebreak();
    }

    private void printComponent(BoundedContext bc) {
        this.sb.append("component").append(" ").append("[" + bc.getName() + "]");
        this.linebreak();
        if (bc.getDomainVisionStatement() != null && !"".equals(bc.getDomainVisionStatement())) {
            this.printNoteForComponent(bc.getDomainVisionStatement(), bc.getName());
        }
    }

    private void printNoteForComponent(String note, String component) {
        this.sb.append("note right of ").append("[").append(component).append("]");
        this.linebreak();
        int charCounter = 0;
        for (String word : note.split(" ")) {
            this.sb.append(word).append(" ");
            if ((charCounter += word.length() + 1) < 30) continue;
            charCounter = 0;
            this.linebreak();
        }
        this.linebreak();
        this.sb.append("end note");
        this.linebreak();
    }

    private void printSymmetricComponentRelationship(String component1, String component2, String name) {
        this.sb.append("[" + component1 + "]").append("<-->").append("[" + component2 + "]").append(" : ").append(name);
        this.linebreak();
    }

    private void printInterface(String interfaceName, String identifier) {
        this.sb.append("interface ").append("\"" + interfaceName + "\"").append(" as ").append(identifier);
        this.linebreak();
    }

    private void printInterfaceUsage(String interfaceId, UpstreamDownstreamRelationship relationship) {
        String downstreamRoleString = this.downstreamRoleToString(relationship.getDownstreamRoles());
        this.sb.append(interfaceId).append(" <.. ").append("[" + relationship.getDownstream().getName() + "]").append(" : ");
        if (relationship instanceof CustomerSupplierRelationship) {
            this.sb.append("Customer ");
        } else if (relationship.getUpstreamExposedAggregates().isEmpty() && "".equals(downstreamRoleString)) {
            this.sb.append("consume");
        } else {
            this.sb.append("use ");
        }
        if (!relationship.getUpstreamExposedAggregates().isEmpty()) {
            if (relationship instanceof CustomerSupplierRelationship) {
                this.sb.append("of ");
            }
            this.sb.append(relationship.getUpstreamExposedAggregates().size() > 1 ? "Aggregates " : "Aggregate ").append(this.aggregatesToCommaSeparatedString(relationship.getUpstreamExposedAggregates())).append(" ");
        }
        if (!"".equals(downstreamRoleString)) {
            this.sb.append(downstreamRoleString);
        }
        this.linebreak();
    }

    private void printUpstreamDownstreamInterfaceExposure(String component, String interfaceId, String[] roles) {
        this.sb.append("[" + component + "]").append(" --> ").append(interfaceId);
        if (roles.length > 0) {
            this.sb.append(" : ").append(String.join((CharSequence)", ", roles));
        }
        this.linebreak();
    }

    private void printCustomerSupplierInterfaceExposure(String component, String interfaceId, String[] roles) {
        this.sb.append("[" + component + "]").append(" --> ").append(interfaceId);
        this.sb.append(" : Supplier");
        if (roles.length > 0) {
            this.sb.append(" of ").append(String.join((CharSequence)", ", roles));
        }
        this.linebreak();
    }

    private String[] upstreamRolesToArray(EList<UpstreamRole> roles) {
        return roles.stream().map(role -> role.getName()).collect(Collectors.toList()).toArray(new String[roles.size()]);
    }

    private String downstreamRoleToString(EList<DownstreamRole> roles) {
        if (roles.isEmpty()) {
            return "";
        }
        if (((DownstreamRole)((Object)roles.get(0))).equals((Object)DownstreamRole.ANTICORRUPTION_LAYER)) {
            return "via " + ((DownstreamRole)((Object)roles.get(0))).getName();
        }
        return "as " + ((DownstreamRole)((Object)roles.get(0))).getName();
    }

    private String aggregatesToCommaSeparatedString(EList<Aggregate> aggregates) {
        return String.join((CharSequence)", ", aggregates.stream().map(aggregate -> aggregate.getName()).collect(Collectors.toList()).toArray(new String[aggregates.size()]));
    }

    private String getRelationshipLabel(Relationship relationship) {
        if (relationship instanceof SymmetricRelationship) {
            return this.getSymmetricRelationshipLabel((SymmetricRelationship)relationship);
        }
        return this.getAsymmetricRelationshipLabel((UpstreamDownstreamRelationship)relationship);
    }

    private String getSymmetricRelationshipLabel(SymmetricRelationship relationship) {
        StringBuilder label = new StringBuilder();
        if (relationship.getName() != null && !"".equals(relationship.getName())) {
            label.append(relationship.getName());
        } else {
            label.append(this.getRelationshipTypeLabel(relationship));
        }
        if (relationship.getImplementationTechnology() != null && !"".equals(relationship.getImplementationTechnology())) {
            label.append(" (").append(relationship.getImplementationTechnology()).append(")");
        }
        return label.toString();
    }

    private String getAsymmetricRelationshipLabel(UpstreamDownstreamRelationship relationship) {
        StringBuilder label = new StringBuilder();
        if (relationship.getName() != null && !"".equals(relationship.getName())) {
            label.append(relationship.getName());
        } else if (relationship instanceof CustomerSupplierRelationship) {
            label.append(this.getRelationshipTypeLabel(relationship));
        }
        if ("".equals(label.toString()) && relationship.getImplementationTechnology() != null && !"".equals(relationship.getImplementationTechnology())) {
            label.append(relationship.getImplementationTechnology());
        } else if (relationship.getImplementationTechnology() != null && !"".equals(relationship.getImplementationTechnology())) {
            label.append(" (").append(relationship.getImplementationTechnology()).append(")");
        }
        if ("".equals(label.toString())) {
            label.append(this.getRelationshipTypeLabel(relationship));
        }
        return label.toString();
    }

    private String getRelationshipTypeLabel(Relationship relationship) {
        if (relationship instanceof Partnership) {
            return "Partnership";
        }
        if (relationship instanceof SharedKernel) {
            return "Shared Kernel";
        }
        if (relationship instanceof CustomerSupplierRelationship) {
            return "Customer-Supplier";
        }
        return "Upstream-Downstream";
    }

    private String getUniqueInterfaceId(String relationshipName, String upstreamName, String downStreamName) {
        if (relationshipName != null && !this.interfaceNames.contains(relationshipName)) {
            this.interfaceNames.add(relationshipName);
            return relationshipName;
        }
        if (!this.interfaceNames.contains(downStreamName + "_to_" + upstreamName)) {
            this.interfaceNames.add(downStreamName + "_to_" + upstreamName);
            return downStreamName + "_to_" + upstreamName;
        }
        return "Interface_" + this.interfaceCounter++;
    }
}

