/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.output.converter;

import ch.hsr.servicecutter.api.model.Service;
import ch.hsr.servicecutter.api.model.ServiceRelation;
import ch.hsr.servicecutter.api.model.SolverResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;

public class ServiceCutterOutputToContextMappingModelConverter {
    private ContextMappingDSLFactory contextMappingFactory = ContextMappingDSLFactory.eINSTANCE;
    private TacticdslFactory tacticDDDFactory = TacticdslFactory.eINSTANCE;
    private Map<String, Entity> entityMap;
    private Map<String, BoundedContext> boundedContextMap;

    public ContextMappingModel convert(SolverResult serviceCutterResult) {
        this.entityMap = new HashMap<String, Entity>();
        this.boundedContextMap = new HashMap<String, BoundedContext>();
        this.initializeEntityMap(serviceCutterResult);
        ContextMappingModel contextMappingModel = this.contextMappingFactory.createContextMappingModel();
        ContextMap contextMap = this.contextMappingFactory.createContextMap();
        for (Service service : serviceCutterResult.getServices()) {
            BoundedContext bc = this.createOrGetBoundedContext(service.getName());
            Aggregate aggregate = this.contextMappingFactory.createAggregate();
            aggregate.setName("Aggregate_" + service.getId());
            aggregate.getDomainObjects().addAll(this.convertEntities(service.getId(), service.getNanoentities()));
            bc.getAggregates().add((Object)aggregate);
            contextMappingModel.getBoundedContexts().add((Object)bc);
            contextMap.getBoundedContexts().add((Object)bc);
        }
        contextMap.getRelationships().addAll(this.convertRelationships(serviceCutterResult.getRelations()));
        contextMappingModel.setMap(contextMap);
        return contextMappingModel;
    }

    private List<Entity> convertEntities(char serviceId, List<String> nanoEntities) {
        ArrayList entities = Lists.newArrayList();
        for (String nanoEntity : nanoEntities) {
            String entityName = serviceId + "_" + nanoEntity.split("\\.")[0];
            String nanoEntityName = nanoEntity.split("\\.")[1];
            Entity entity = this.entityMap.get(entityName);
            entities.add(entity);
            Attribute attribute = this.tacticDDDFactory.createAttribute();
            attribute.setType("UnknownType");
            attribute.setName(nanoEntityName);
            entity.getAttributes().add((Object)attribute);
        }
        return entities;
    }

    private List<Relationship> convertRelationships(List<ServiceRelation> serviceRelations) {
        ArrayList relationships = Lists.newArrayList();
        for (ServiceRelation relation : serviceRelations) {
            if ("OUTGOING".equals(relation.getDirection().toString())) {
                relationships.add(this.createUpstreamDownstreamRelationship(this.createOrGetBoundedContext(relation.getServiceA()), this.createOrGetBoundedContext(relation.getServiceB())));
                continue;
            }
            if ("INCOMING".equals(relation.getDirection().toString())) {
                relationships.add(this.createUpstreamDownstreamRelationship(this.createOrGetBoundedContext(relation.getServiceB()), this.createOrGetBoundedContext(relation.getServiceA())));
                continue;
            }
            if (!"BIDIRECTIONAL".equals(relation.getDirection().toString())) continue;
            relationships.add(this.createSharedKernelRelationship(this.createOrGetBoundedContext(relation.getServiceA()), this.createOrGetBoundedContext(relation.getServiceB())));
        }
        return relationships;
    }

    private UpstreamDownstreamRelationship createUpstreamDownstreamRelationship(BoundedContext source, BoundedContext target) {
        UpstreamDownstreamRelationship relationship = this.contextMappingFactory.createUpstreamDownstreamRelationship();
        relationship.setUpstream(target);
        relationship.setDownstream(source);
        return relationship;
    }

    private SharedKernel createSharedKernelRelationship(BoundedContext context1, BoundedContext context2) {
        SharedKernel sharedKernel = this.contextMappingFactory.createSharedKernel();
        sharedKernel.setParticipant1(context1);
        sharedKernel.setParticipant2(context2);
        return sharedKernel;
    }

    private void initializeEntityMap(SolverResult serviceCutterResult) {
        for (Service service : serviceCutterResult.getServices()) {
            this.initializeEntityMap(service);
        }
    }

    private void initializeEntityMap(Service service) {
        for (String nanoEntity : service.getNanoentities()) {
            String entityName = nanoEntity.split("\\.")[0];
            this.addEntityToEntityMapIfNotExisting(service.getId() + "_" + entityName);
        }
    }

    private void addEntityToEntityMapIfNotExisting(String entityName) {
        if (!this.entityMap.containsKey(entityName)) {
            Entity entity = this.tacticDDDFactory.createEntity();
            entity.setName(entityName);
            this.entityMap.put(entityName, entity);
        }
    }

    private BoundedContext createOrGetBoundedContext(String serviceName) {
        String boundedContextName = this.getBoundedContextName(serviceName);
        if (!this.boundedContextMap.containsKey(boundedContextName)) {
            BoundedContext bc = this.contextMappingFactory.createBoundedContext();
            bc.setName(boundedContextName);
            this.boundedContextMap.put(boundedContextName, bc);
        }
        return this.boundedContextMap.get(boundedContextName);
    }

    private String getBoundedContextName(String serviceName) {
        return serviceName.replace(" ", "_");
    }
}

