/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.Refactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;

public abstract class AbstractExtractSymmetricRelationshipRefactoring
extends AbstractRefactoring
implements Refactoring {
    protected String boundedContext1;
    protected String boundedContext2;
    protected ContextMap contextMap;

    public AbstractExtractSymmetricRelationshipRefactoring(String boundedContext1, String boundedContext2) {
        this.boundedContext1 = boundedContext1;
        this.boundedContext2 = boundedContext2;
    }

    @Override
    protected void doRefactor() {
        this.checkPreconditions();
        this.contextMap = this.model.getMap();
        this.contextMap.getRelationships().remove((Object)this.getMatchingRelationship());
        BoundedContext newBC = this.createBoundedContext();
        this.model.getBoundedContexts().add((Object)newBC);
        this.contextMap.getBoundedContexts().add((Object)newBC);
        UpstreamDownstreamRelationship relationship1 = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        relationship1.setUpstream(newBC);
        relationship1.setDownstream(this.getBoundedContext(this.boundedContext1));
        UpstreamDownstreamRelationship relationship2 = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        relationship2.setUpstream(newBC);
        relationship2.setDownstream(this.getBoundedContext(this.boundedContext2));
        this.contextMap.getRelationships().add((Object)relationship1);
        this.contextMap.getRelationships().add((Object)relationship2);
        this.saveResources();
    }

    abstract List<SymmetricRelationship> getMatchingRelationships();

    abstract String getRelationshipType();

    protected BoundedContext createBoundedContext() {
        BoundedContext newBC = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        newBC.setName(this.getNewBoundedContextName());
        return newBC;
    }

    private void checkPreconditions() {
        if (this.model.getMap() == null) {
            throw new RefactoringInputException("The selected model does not conain a Context Map. Please select a CML file containing a ContextMap element.");
        }
        if (this.boundedContext1 == null || this.boundedContext2 == null) {
            throw new RefactoringInputException("Please provide two bounded context names (input parameter was null).");
        }
        if (this.boundedContext1.equals(this.boundedContext2)) {
            throw new RefactoringInputException("Please provide two different bounded context names (input parameters contain same name).");
        }
        List<SymmetricRelationship> matchingRelationships = this.getMatchingRelationships();
        if (matchingRelationships.size() > 1) {
            throw new RefactoringInputException("There are multiple " + this.getRelationshipType() + " relationships between '" + this.boundedContext1 + "' and '" + this.boundedContext2 + "'.");
        }
        if (matchingRelationships.isEmpty()) {
            throw new RefactoringInputException("Your Context Map does not contain a " + this.getRelationshipType() + " relationship between '" + this.boundedContext1 + "' and '" + this.boundedContext2 + "'.");
        }
    }

    private BoundedContext getBoundedContext(String name) {
        return this.contextMap.getBoundedContexts().stream().filter(bc -> bc.getName().equals(name)).findFirst().get();
    }

    private SymmetricRelationship getMatchingRelationship() {
        return this.getMatchingRelationships().get(0);
    }

    private String getNewBoundedContextName() {
        String name;
        Set existingNames = this.model.getBoundedContexts().stream().map(bc -> bc.getName()).collect(Collectors.toSet());
        if (existingNames.contains(name = this.boundedContext1 + "_" + this.boundedContext2 + "_" + this.getRelationshipType())) {
            int counter = 1;
            while (existingNames.contains(name)) {
                name = this.boundedContext1 + "_" + this.boundedContext2 + "_" + this.getRelationshipType() + "_" + counter;
                ++counter;
            }
        }
        return name;
    }
}

