/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.contextmapper.dsl.cml.CMLImportResolver;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Import;
import org.contextmapper.dsl.refactoring.Refactoring;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.SaveOptions;

public abstract class AbstractRefactoring
implements Refactoring {
    protected ContextMappingModel model;
    protected CMLResourceContainer rootResource;
    protected Set<CMLResourceContainer> importedResources;
    private Map<BoundedContext, CMLResourceContainer> boundedContextsMap = Maps.newHashMap();
    private Map<ContextMap, CMLResourceContainer> contextMapMap = Maps.newHashMap();
    private List<CMLResourceContainer> changedResources = Lists.newArrayList();
    protected ResourceSet consistencyCheckResources;
    protected Set<CMLResourceContainer> additionalResourcesToCheck = Sets.newHashSet();

    @Override
    public void doRefactor(CMLResourceContainer resource) {
        this.rootResource = resource;
        this.importedResources = new CMLImportResolver().resolveImportedResources(this.rootResource);
        this.model = resource.getContextMappingModel();
        this.resolveRootElements();
        this.doRefactor();
    }

    @Override
    public void doRefactor(CMLResourceContainer resource, ResourceSet consistencyCheckResources) {
        this.consistencyCheckResources = consistencyCheckResources;
        for (Resource resourceToCheck : consistencyCheckResources.getResources()) {
            if (resourceToCheck.getContents().isEmpty() || !(resourceToCheck.getContents().get(0) instanceof ContextMappingModel)) continue;
            this.additionalResourcesToCheck.add(new CMLResourceContainer(resourceToCheck));
        }
        this.doRefactor(resource);
    }

    protected abstract void doRefactor();

    protected Set<BoundedContext> getAllBoundedContexts() {
        return Sets.newHashSet(this.boundedContextsMap.keySet());
    }

    protected Set<ContextMap> getAllContextMaps() {
        return Sets.newHashSet(this.contextMapMap.keySet());
    }

    protected void saveResource(Resource resource) {
        try {
            resource.save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
        }
        catch (IOException e) {
            throw new RuntimeException("Document cannot be formatted.");
        }
    }

    protected void saveResources() {
        this.rootResource.getContextMappingModel().eAllContents();
        this.saveResource(this.rootResource.getResource());
        for (CMLResourceContainer changedResource : this.changedResources) {
            changedResource.getContextMappingModel().eAllContents();
            this.saveResource(changedResource.getResource());
        }
    }

    protected void markResourceChanged(BoundedContext changedBoundedContext) {
        CMLResourceContainer resource = this.getResource(changedBoundedContext);
        this.markResourceChanged(resource);
    }

    protected void markResourceChanged(ContextMap changedContextMap) {
        this.markResourceChanged(this.getResource(changedContextMap));
    }

    protected void markResourceChanged(CMLResourceContainer resource) {
        this.changedResources.add(resource);
    }

    protected CMLResourceContainer getResource(BoundedContext bc) {
        CMLResourceContainer result = this.boundedContextsMap.get(bc);
        return result;
    }

    protected CMLResourceContainer getResource(ContextMap contextMap) {
        return this.contextMapMap.get(contextMap);
    }

    private void resolveRootElements() {
        this.resolveBoundedContexts(this.rootResource);
        this.resolveContextMaps(this.rootResource);
        for (CMLResourceContainer importedResource : this.importedResources) {
            this.resolveBoundedContexts(importedResource);
            this.resolveContextMaps(importedResource);
        }
    }

    private void resolveBoundedContexts(CMLResourceContainer resource) {
        for (BoundedContext bc : resource.getContextMappingModel().getBoundedContexts()) {
            this.boundedContextsMap.put(bc, resource);
        }
    }

    private void resolveContextMaps(CMLResourceContainer resource) {
        if (resource.getContextMappingModel().getMap() != null) {
            this.contextMapMap.put(resource.getContextMappingModel().getMap(), resource);
        }
        for (CMLResourceContainer extResourceToCheck : this.additionalResourcesToCheck) {
            if (extResourceToCheck.getContextMappingModel().getMap() == null || !this.containsImport(extResourceToCheck, resource)) continue;
            this.contextMapMap.put(extResourceToCheck.getContextMappingModel().getMap(), extResourceToCheck);
        }
    }

    private boolean containsImport(CMLResourceContainer source, CMLResourceContainer target) {
        for (Import cmlImport : source.getContextMappingModel().getImports()) {
            if (!URI.createURI((String)cmlImport.getImportURI()).resolve(source.getResource().getURI()).toString().equals(target.getResource().getURI().toString())) continue;
            return true;
        }
        return false;
    }

    protected <T> void addElementsToEList(EList<T> list, List<T> elementsToAdd) {
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
        list.addAll(elementsToAdd);
    }

    protected <T> void addElementToEList(EList<T> list, T elementToAdd) {
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
        list.add(elementToAdd);
    }

    protected <T> void removeElementFromEList(EList<T> list, T object) {
        list.remove(object);
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
    }
}

