/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Partnership;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.Refactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;

public class ChangePartnershipToUpstreamDownstreamRefactoring
extends AbstractRefactoring
implements Refactoring {
    protected String upstreamContext;
    protected String downstreamContext;

    public ChangePartnershipToUpstreamDownstreamRefactoring(String upstreamContext, String downstreamContext) {
        this.upstreamContext = upstreamContext;
        this.downstreamContext = downstreamContext;
    }

    @Override
    protected void doRefactor() {
        this.checkPreconditions();
        ContextMap contextMap = this.model.getMap();
        this.removeElementFromEList(contextMap.getRelationships(), this.getMatchingRelationship());
        UpstreamDownstreamRelationship relationship = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        relationship.setUpstream(this.getBoundedContext(this.upstreamContext));
        relationship.setDownstream(this.getBoundedContext(this.downstreamContext));
        this.addElementToEList(contextMap.getRelationships(), relationship);
        this.saveResources();
    }

    List<SymmetricRelationship> getMatchingRelationships() {
        return this.model.getMap().getRelationships().stream().filter(rel -> rel instanceof Partnership).map(rel -> (Partnership)rel).filter(p -> p.getParticipant1().getName().equals(this.upstreamContext) && p.getParticipant2().getName().equals(this.downstreamContext) || p.getParticipant1().getName().equals(this.downstreamContext) && p.getParticipant2().getName().equals(this.upstreamContext)).collect(Collectors.toList());
    }

    private void checkPreconditions() {
        if (this.upstreamContext == null || this.downstreamContext == null) {
            throw new RefactoringInputException("Please provide two bounded context names (input parameter was null).");
        }
        if (this.upstreamContext.equals(this.downstreamContext)) {
            throw new RefactoringInputException("Please provide two different bounded context names (input parameters contain same name).");
        }
        List<SymmetricRelationship> matchingRelationships = this.getMatchingRelationships();
        if (matchingRelationships.size() > 1) {
            throw new RefactoringInputException("There are multiple Partnership relationships between '" + this.upstreamContext + "' and '" + this.downstreamContext + "'.");
        }
        if (matchingRelationships.isEmpty()) {
            throw new RefactoringInputException("Your Context Map does not contain a Partnership relationship between '" + this.upstreamContext + "' and '" + this.downstreamContext + "'.");
        }
    }

    private BoundedContext getBoundedContext(String name) {
        return this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(name)).findFirst().get();
    }

    private SymmetricRelationship getMatchingRelationship() {
        return this.getMatchingRelationships().get(0);
    }
}

