/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.Refactoring;

public class ExtractAggregatesByCohesion
extends AbstractRefactoring
implements Refactoring {
    private String boundedContextName;
    private BoundedContext originalBC;
    private String newBoundedContextName;
    private List<String> aggregatesToExtract;

    public ExtractAggregatesByCohesion(String boundedContextName, String newBoundedContextName, List<String> aggregatesToExtract) {
        this.boundedContextName = boundedContextName;
        this.newBoundedContextName = newBoundedContextName;
        this.aggregatesToExtract = aggregatesToExtract;
    }

    @Override
    protected void doRefactor() {
        this.initOriginalBC();
        if (this.aggregatesToExtract.size() < 1) {
            return;
        }
        BoundedContext newBC = this.createNewBoundedContext();
        for (String aggregateName : this.aggregatesToExtract) {
            Optional<Aggregate> aggregate = this.originalBC.getAggregates().stream().filter(agg -> agg.getName().equals(aggregateName)).findFirst();
            if (!aggregate.isPresent()) continue;
            this.removeElementFromEList(this.originalBC.getAggregates(), aggregate.get());
            this.addElementToEList(newBC.getAggregates(), aggregate.get());
            this.markResourceChanged(this.originalBC);
        }
        this.getResource(this.originalBC).getContextMappingModel().getBoundedContexts().add((Object)newBC);
        for (ContextMap contextMap : this.getAllContextMaps()) {
            new ContextMappingModelHelper(contextMap).moveExposedAggregatesToNewRelationshipsIfNeeded(this.aggregatesToExtract, newBC);
            this.markResourceChanged(contextMap);
        }
        this.saveResources();
    }

    private BoundedContext createNewBoundedContext() {
        BoundedContext bc = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        bc.setName(this.newBoundedContextName);
        return bc;
    }

    private void initOriginalBC() {
        List bcsWithGivenInputName = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.boundedContextName)).collect(Collectors.toList());
        this.originalBC = (BoundedContext)bcsWithGivenInputName.get(0);
    }
}

