/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.refactoring.AbstractExtractSymmetricRelationshipRefactoring;
import org.contextmapper.dsl.refactoring.Refactoring;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;

public class ExtractSharedKernelRefactoring
extends AbstractExtractSymmetricRelationshipRefactoring
implements Refactoring {
    public ExtractSharedKernelRefactoring(String boundedContext1, String boundedContext2) {
        super(boundedContext1, boundedContext2);
    }

    @Override
    List<SymmetricRelationship> getMatchingRelationships() {
        return this.model.getMap().getRelationships().stream().filter(rel -> rel instanceof SharedKernel).map(rel -> (SharedKernel)rel).filter(sk -> sk.getParticipant1().getName().equals(this.boundedContext1) && sk.getParticipant2().getName().equals(this.boundedContext2)).collect(Collectors.toList());
    }

    @Override
    String getRelationshipType() {
        return "SharedKernel";
    }

    @Override
    protected BoundedContext createBoundedContext() {
        BoundedContext newBC = super.createBoundedContext();
        newBC.setComment("// Extracted Bounded Context for Shared Kernel. Please specify the kernel model here:");
        Aggregate aggregate = ContextMappingDSLFactory.eINSTANCE.createAggregate();
        aggregate.setName("SharedKernelAggregate");
        Entity entity = TacticdslFactory.eINSTANCE.createEntity();
        entity.setAggregateRoot(true);
        entity.setName("SharedKernelRoot");
        this.addElementToEList(aggregate.getDomainObjects(), entity);
        this.addElementToEList(newBC.getAggregates(), aggregate);
        return newBC;
    }
}

