/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Import;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.Refactoring;
import org.eclipse.emf.common.util.URI;

public class MergeBoundedContextsRefactoring
extends AbstractRefactoring
implements Refactoring {
    private String boundedContext1;
    private String boundedContext2;
    private boolean takeAttributesFromSecondBoundedContext = false;

    public MergeBoundedContextsRefactoring(String boundedContext1, String boundedContext2) {
        this.boundedContext1 = boundedContext1;
        this.boundedContext2 = boundedContext2;
    }

    public MergeBoundedContextsRefactoring(String boundedContext1, String boundedContext2, boolean takeAttributesFromSecondBoundedContext) {
        this(boundedContext1, boundedContext2);
        this.takeAttributesFromSecondBoundedContext = takeAttributesFromSecondBoundedContext;
    }

    @Override
    protected void doRefactor() {
        if (this.boundedContext1.equals(this.boundedContext2)) {
            return;
        }
        Optional<BoundedContext> optionalBC1 = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.boundedContext1)).findFirst();
        Optional<BoundedContext> optionalBC2 = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.boundedContext2)).findFirst();
        if (!optionalBC1.isPresent() || !optionalBC2.isPresent()) {
            return;
        }
        BoundedContext bc1 = optionalBC1.get();
        BoundedContext bc2 = optionalBC2.get();
        if (this.takeAttributesFromSecondBoundedContext) {
            bc1 = optionalBC2.get();
            bc2 = optionalBC1.get();
        }
        this.addElementsToEList(bc1.getAggregates(), bc2.getAggregates());
        this.addElementsToEList(bc1.getModules(), bc2.getModules());
        bc1.getImplementedDomainParts().addAll(bc2.getImplementedDomainParts());
        if (bc1.getType().equals((Object)BoundedContextType.TEAM)) {
            bc1.getRealizedBoundedContexts().addAll(bc2.getRealizedBoundedContexts());
        }
        bc1.getResponsibilities().addAll(bc2.getResponsibilities());
        bc1.setImplementationTechnology(this.mergeImplementationTechnologies(bc1.getImplementationTechnology(), bc2.getImplementationTechnology()));
        this.handleContextMapChanges(bc1, bc2);
        this.handleImportsToRemovedBC(bc1, bc2);
        ContextMappingModel bc2Model = this.getResource(bc2).getContextMappingModel();
        this.removeElementFromEList(bc2Model.getBoundedContexts(), bc2);
        bc2Model.eAllContents();
        if (bc2Model.getMap() == null && bc2Model.getBoundedContexts().isEmpty()) {
            bc2Model.setFirstLineComment("// Due to the application of 'Merge Bounded Contexts' this file no longer contains any Bounded Contexts.");
        }
        this.markResourceChanged(bc1);
        this.markResourceChanged(bc2);
        this.saveResources();
    }

    private String mergeImplementationTechnologies(String implementationTechnology1, String implementationTechnology2) {
        if (implementationTechnology1 == null && implementationTechnology2 == null) {
            return null;
        }
        HashSet implementationTechnologies = Sets.newHashSet();
        if (implementationTechnology1 != null && !"".equals(implementationTechnology1)) {
            implementationTechnologies.add(implementationTechnology1);
        }
        if (implementationTechnology2 != null && !"".equals(implementationTechnology2)) {
            implementationTechnologies.add(implementationTechnology2);
        }
        return String.join((CharSequence)", ", implementationTechnologies);
    }

    private void handleContextMapChanges(BoundedContext mergedBC, BoundedContext removedBC) {
        for (ContextMap map : this.getAllContextMaps()) {
            ContextMappingModelHelper helper = new ContextMappingModelHelper(map);
            List<Relationship> relationshipsToRemove = helper.findAnyRelationshipsBetweenTwoContexts(mergedBC, removedBC);
            map.getRelationships().removeAll(relationshipsToRemove);
            helper.replaceBCInAllRelationships(removedBC, mergedBC);
            if (map.getBoundedContexts().stream().map(bc -> bc.getName()).collect(Collectors.toSet()).contains(removedBC.getName())) {
                BoundedContext bcToRemove = map.getBoundedContexts().stream().filter(bc -> bc.getName().equals(removedBC.getName())).findFirst().get();
                this.removeElementFromEList(map.getBoundedContexts(), bcToRemove);
            }
            this.markResourceChanged(map);
        }
    }

    private void handleImportsToRemovedBC(BoundedContext mergedBC, BoundedContext removedBC) {
        CMLResourceContainer mergedBCResource = this.getResource(mergedBC);
        CMLResourceContainer removedBCResource = this.getResource(removedBC);
        URI mergedBCURI = mergedBCResource.getResource().getURI();
        URI removedBCURI = removedBCResource.getResource().getURI();
        if (mergedBCResource.getResource().getURI().toString().equals(removedBCResource.getResource().getURI().toString())) {
            return;
        }
        Import importToRemovedBCResource = ContextMappingDSLFactory.eINSTANCE.createImport();
        importToRemovedBCResource.setImportURI(removedBCURI.toString());
        mergedBCResource.getContextMappingModel().getImports().add((Object)importToRemovedBCResource);
        for (CMLResourceContainer resource : this.additionalResourcesToCheck) {
            Set importedURIs = resource.getContextMappingModel().getImports().stream().map(i -> URI.createURI((String)i.getImportURI()).resolve(resource.getResource().getURI())).collect(Collectors.toSet());
            if (mergedBCURI.toString().equals(resource.getResource().getURI().toString()) || !importedURIs.contains(removedBCURI) || importedURIs.contains(mergedBCURI)) continue;
            Import importToAdd = ContextMappingDSLFactory.eINSTANCE.createImport();
            importToAdd.setImportURI(mergedBCURI.toString());
            resource.getContextMappingModel().getImports().add((Object)importToAdd);
            this.markResourceChanged(resource);
        }
    }
}

