/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.henshin;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.contextmapper.dsl.refactoring.henshin.HenshinFileExportException;

public class HenshinTransformationFileProvider {
    public static final String SPLIT_AGGREGATE_BY_ENTITIES = "SplitAggregateByEntities.henshin";
    public static final String SPLIT_AGGREGATE_BY_ENTITIES_IN_MODULE = "SplitAggregateByEntities_WithModule.henshin";
    private File henshinDirectory = new File(System.getProperty("java.io.tmpdir"), this.getTempFolderName());

    public String getTransformationFilePath(String transformationFileName) {
        File tempFile = new File(this.henshinDirectory, transformationFileName);
        if (!tempFile.exists()) {
            this.copyFileToTempDirectory(transformationFileName);
        }
        return tempFile.getAbsolutePath();
    }

    public void prepareAllHenshinFiles() {
        try {
            if (this.henshinDirectory.exists()) {
                FileUtils.cleanDirectory((File)this.henshinDirectory);
            }
            this.copyFileToTempDirectory(SPLIT_AGGREGATE_BY_ENTITIES);
            this.copyFileToTempDirectory(SPLIT_AGGREGATE_BY_ENTITIES_IN_MODULE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyFileToTempDirectory(String henshinFile) {
        if (!this.henshinDirectory.exists()) {
            this.henshinDirectory.mkdir();
        }
        URL url = this.getClass().getResource(henshinFile);
        try {
            FileUtils.copyURLToFile((URL)url, (File)new File(this.henshinDirectory, henshinFile));
        }
        catch (Exception e) {
            throw new HenshinFileExportException();
        }
    }

    private String getTempFolderName() {
        return "context-mapper-henshin-transformations-" + this.getPID();
    }

    public File getHenshinDirectory() {
        return this.henshinDirectory;
    }

    public long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }
}

