/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.UseCase;
import org.contextmapper.dsl.validation.AbstractCMLValidator;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class UniquenessValidator
extends AbstractCMLValidator {
    private CMLModelObjectsResolvingHelper resolvingHelper = new CMLModelObjectsResolvingHelper();

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateThatBoundedContextNameIsUnique(BoundedContext bc) {
        Iterator<BoundedContext> allBoundedContexts;
        Iterator duplicateBoundedContexts;
        if (bc != null && IteratorExtensions.size((Iterator)(duplicateBoundedContexts = IteratorExtensions.filter(allBoundedContexts = this.resolvingHelper.resolveAllObjectsOfType(this.getRootCMLModel(bc), BoundedContext.class).iterator(), boundedcontext -> boundedcontext.getName().equals(bc.getName())))) > 1) {
            this.error(String.format("Multiple bounded contexts with the name '%s' have been declared.", bc.getName()), bc, (EStructuralFeature)ContextMappingDSLPackage.Literals.BOUNDED_CONTEXT__NAME);
        }
    }

    @Check
    public void validateThatModuleNameIsUnique(SculptorModule module) {
        Iterator<SculptorModule> allModules;
        Iterator duplicateModules;
        if (module != null && IteratorExtensions.size((Iterator)(duplicateModules = IteratorExtensions.filter(allModules = this.resolvingHelper.resolveAllObjectsOfType(this.getRootCMLModel(module), SculptorModule.class).iterator(), m -> m.getName().equals(module.getName())))) > 1) {
            this.error(String.format("Duplicate name. There is already an existing Module named '%s'.", module.getName()), module, (EStructuralFeature)ContextMappingDSLPackage.Literals.SCULPTOR_MODULE__NAME);
        }
    }

    @Check
    public void validateThatAggregateNameIsUnique(Aggregate aggregate) {
        Iterator<Aggregate> allAggregates;
        Iterator duplicateAggregates;
        if (aggregate != null && IteratorExtensions.size((Iterator)(duplicateAggregates = IteratorExtensions.filter(allAggregates = this.resolvingHelper.resolveAllObjectsOfType(this.getRootCMLModel(aggregate), Aggregate.class).iterator(), a -> a.getName().equals(aggregate.getName())))) > 1) {
            this.error(String.format("Multiple aggregates with the name '%s' have been declared.", aggregate.getName()), aggregate, (EStructuralFeature)ContextMappingDSLPackage.Literals.AGGREGATE__NAME);
        }
    }

    @Check
    public void validateThatUseCaseNameIsUnique(UseCase uc) {
        Iterator<UseCase> allUseCases;
        Iterator duplicateUseCases;
        if (uc != null && IteratorExtensions.size((Iterator)(duplicateUseCases = IteratorExtensions.filter(allUseCases = this.resolvingHelper.resolveAllObjectsOfType(this.getRootCMLModel(uc), UseCase.class).iterator(), u -> u.getName().equals(uc.getName())))) > 1) {
            this.error(String.format("Multiple use cases with the name '%s' have been declared.", uc.getName()), uc, (EStructuralFeature)ContextMappingDSLPackage.Literals.USE_CASE__NAME);
        }
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInAggregate(Aggregate agg) {
        if (agg == null) {
            return;
        }
        this.checkDomainObjectUnique((List<SimpleDomainObject>)agg.getDomainObjects());
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInModule(SculptorModule module) {
        if (module == null) {
            return;
        }
        this.checkDomainObjectUnique((List<SimpleDomainObject>)module.getDomainObjects());
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInSubdomain(Subdomain subdomain) {
        if (subdomain == null) {
            return;
        }
        this.checkDomainObjectUnique(subdomain.getEntities().stream().map(e -> e).collect(Collectors.toList()));
    }

    private void checkDomainObjectUnique(List<SimpleDomainObject> domainObjects) {
        HashSet<String> usedNames = new HashSet<String>();
        for (SimpleDomainObject o : domainObjects) {
            if (o.getName() == null) continue;
            if (usedNames.contains(o.getName())) {
                this.error(String.format("Multiple domain objects with the name '%s' have been declared.", o.getName()), o, (EStructuralFeature)TacticdslPackage.Literals.SIMPLE_DOMAIN_OBJECT__NAME);
                continue;
            }
            usedNames.add(o.getName());
        }
    }
}

