/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.tactic.dsl.tacticdsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HttpMethod implements Enumerator
{
    NONE(0, "None", "None"),
    GET(1, "GET", "GET"),
    POST(2, "POST", "POST"),
    PUT(3, "PUT", "PUT"),
    DELETE(4, "DELETE", "DELETE");

    public static final int NONE_VALUE = 0;
    public static final int GET_VALUE = 1;
    public static final int POST_VALUE = 2;
    public static final int PUT_VALUE = 3;
    public static final int DELETE_VALUE = 4;
    private static final HttpMethod[] VALUES_ARRAY;
    public static final List<HttpMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static HttpMethod get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HttpMethod result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static HttpMethod getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HttpMethod result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static HttpMethod get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GET;
            }
            case 2: {
                return POST;
            }
            case 3: {
                return PUT;
            }
            case 4: {
                return DELETE;
            }
        }
        return null;
    }

    private HttpMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new HttpMethod[]{NONE, GET, POST, PUT, DELETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

