/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.tactic.dsl.tacticdsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Visibility implements Enumerator
{
    PUBLIC(0, "public", "public"),
    PROTECTED(1, "protected", "protected"),
    PRIVATE(2, "private", "private"),
    PACKAGE(3, "package", "package");

    public static final int PUBLIC_VALUE = 0;
    public static final int PROTECTED_VALUE = 1;
    public static final int PRIVATE_VALUE = 2;
    public static final int PACKAGE_VALUE = 3;
    private static final Visibility[] VALUES_ARRAY;
    public static final List<Visibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Visibility get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Visibility result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Visibility getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Visibility result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Visibility get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
            case 3: {
                return PACKAGE;
            }
        }
        return null;
    }

    private Visibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Visibility[]{PUBLIC, PROTECTED, PRIVATE, PACKAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

