/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.analyzer;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.model.Service;
import ch.hsr.servicecutter.api.model.ServiceRelation;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.InstanceType;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.Score;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCutAnalyzer {
    private Logger log = LoggerFactory.getLogger(ServiceCutAnalyzer.class);
    private ServiceCutterContext context;

    public ServiceCutAnalyzer(ServiceCutterContext context) {
        this.context = context;
    }

    private Nanoentity findNanoentity(String nanoentityName) {
        Nanoentity nanoentity;
        if (nanoentityName.contains(".")) {
            String[] splittedName = nanoentityName.split("\\.");
            nanoentity = this.context.getNanoEntities().stream().filter(ne -> splittedName[0].equals(ne.getContext()) && splittedName[1].equals(ne.getName())).findFirst().get();
        } else {
            nanoentity = this.context.getNanoEntities().stream().filter(ne -> nanoentityName.equals(ne.getName())).findFirst().get();
        }
        return nanoentity;
    }

    public void analyseResult(SolverResult solverResult, Map<EntityPair, Map<String, Score>> scores) {
        Map<Service, List<CouplingInstance>> useCaseResponsibilites = this.getUseCaseResponsibilites(solverResult.getServices());
        solverResult.setUseCaseResponsibility(this.transformResponsibilityMap(useCaseResponsibilites));
        for (Map.Entry<String, List<String>> responsibility : solverResult.getUseCaseResponsibility().entrySet()) {
            this.log.info("attach use cases {} to service {}", (Object)responsibility.getValue().toString(), (Object)responsibility.getKey());
        }
        ArrayList<Service> serviceList = new ArrayList<Service>(solverResult.getServices());
        ArrayList<ServiceRelation> relations = new ArrayList<ServiceRelation>();
        for (int a = 0; a < serviceList.size() - 1; ++a) {
            for (int b = a + 1; b < serviceList.size(); ++b) {
                Service serviceA = (Service)serviceList.get(a);
                Service serviceB = (Service)serviceList.get(b);
                Double score = this.getProximityScoreFor(serviceA, serviceB, scores);
                ServiceRelation relation = this.createServiceRelation(serviceA, serviceB, useCaseResponsibilites);
                if (!(score > 0.0) || relation.getSharedEntities().isEmpty()) continue;
                this.log.info("create service relation for services {} and {} with score {} and nanoentities {}", new Object[]{serviceA.getName(), serviceB.getName(), score, relation.getSharedEntities().toString()});
                relations.add(relation);
            }
        }
        solverResult.setRelations(relations);
    }

    private ServiceRelation createServiceRelation(Service serviceA, Service serviceB, Map<Service, List<CouplingInstance>> useCaseResponsibilites) {
        HashSet<String> sharedNanoentities = new HashSet<String>();
        List<String> aToB = this.getSharedNanoentities(useCaseResponsibilites.get(serviceA), serviceB);
        sharedNanoentities.addAll(aToB);
        List<String> bToA = this.getSharedNanoentities(useCaseResponsibilites.get(serviceB), serviceA);
        sharedNanoentities.addAll(bToA);
        ServiceRelation.Direction direction = null;
        if (!aToB.isEmpty() && !bToA.isEmpty()) {
            direction = ServiceRelation.Direction.BIDIRECTIONAL;
        } else if (!aToB.isEmpty()) {
            direction = ServiceRelation.Direction.OUTGOING;
        } else if (!bToA.isEmpty()) {
            direction = ServiceRelation.Direction.INCOMING;
        }
        return new ServiceRelation(sharedNanoentities, serviceA.getName(), serviceB.getName(), direction);
    }

    private List<String> getSharedNanoentities(List<CouplingInstance> primaryUseCases, Service otherService) {
        if (primaryUseCases == null || primaryUseCases.isEmpty()) {
            return Collections.emptyList();
        }
        return primaryUseCases.stream().flatMap(instance -> instance.getAllNanoentities().stream().filter(nanoentity -> otherService.getNanoentities().contains(nanoentity.getContextName()))).map(nanoentity -> nanoentity.getContextName()).collect(Collectors.toList());
    }

    private Map<String, List<String>> transformResponsibilityMap(Map<Service, List<CouplingInstance>> useCaseResponsibilites) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<Service, List<CouplingInstance>> responsibility : useCaseResponsibilites.entrySet()) {
            if (responsibility.getKey() == null) continue;
            result.put(responsibility.getKey().getName(), responsibility.getValue().stream().map(instance -> instance.getName()).collect(Collectors.toList()));
        }
        return result;
    }

    private Map<Service, List<CouplingInstance>> getUseCaseResponsibilites(Set<Service> set) {
        HashMap<Service, List<CouplingInstance>> useCaseResponsibilites = new HashMap<Service, List<CouplingInstance>>();
        this.context.getCouplingInstances().stream().filter(instance -> InstanceType.USE_CASE.equals((Object)instance.getType()) || InstanceType.LATENCY_USE_CASE.equals((Object)instance.getType())).forEach(instance -> {
            Service responsibleService = this.getResponsibleService(set, (CouplingInstance)instance);
            if (responsibleService == null) {
                throw new RuntimeException("Responsible service for " + instance.getName() + " not found!");
            }
            if (useCaseResponsibilites.get(responsibleService) == null) {
                useCaseResponsibilites.put(responsibleService, new ArrayList());
            }
            ((List)useCaseResponsibilites.get(responsibleService)).add(instance);
        });
        return useCaseResponsibilites;
    }

    private Service getResponsibleService(Set<Service> set, CouplingInstance dualInstance) {
        double SCORE_WRITE = 1.0;
        double SCORE_READ = 0.25;
        Service responsibleService = null;
        Double highestScore = 0.0;
        for (Service service : set) {
            long numberOfNanoentitiesWritten = dualInstance.getSecondNanoentities().stream().filter(nanoentity -> service.getNanoentities().contains(nanoentity.getContextName())).count();
            long numberOfNanoentitiesRead = dualInstance.getNanoentities().stream().filter(nanoentity -> service.getNanoentities().contains(nanoentity.getContextName())).count();
            double score = (double)numberOfNanoentitiesRead * 0.25 + (double)numberOfNanoentitiesWritten * 1.0;
            if (!(score > highestScore)) continue;
            highestScore = score;
            responsibleService = service;
        }
        return responsibleService;
    }

    private Double getProximityScoreFor(Service serviceA, Service serviceB, Map<EntityPair, Map<String, Score>> scores) {
        Double score = 0.0;
        for (String nanoentityA : serviceA.getNanoentities()) {
            for (String nanoentityB : serviceB.getNanoentities()) {
                Score semanticProximityScore;
                EntityPair nanoentityTuple = new EntityPair(this.findNanoentity(nanoentityA), this.findNanoentity(nanoentityB));
                Map<String, Score> scoresByTuple = scores.get(nanoentityTuple);
                if (scoresByTuple == null || (semanticProximityScore = scoresByTuple.get("Semantic Proximity")) == null) continue;
                score = score + semanticProximityScore.getPrioritizedScore();
            }
        }
        return score;
    }
}

