/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.scorer.criterionScorer;

import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.criterionScorer.CriterionScorer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RelatedGroupCriteriaScorer
implements CriterionScorer {
    private double penalty;
    private double premium;
    private Iterable<Nanoentity> allNanoentities;
    private boolean penaltyToOtherGroups;
    private boolean penaltyToAll;

    public RelatedGroupCriteriaScorer(double penalty, double premium, Iterable<Nanoentity> iterable, boolean penaltyToOtherGroups, boolean penaltyToAll) {
        this.penalty = penalty;
        this.premium = premium;
        this.allNanoentities = iterable;
        this.penaltyToOtherGroups = penaltyToOtherGroups;
        this.penaltyToAll = penaltyToAll;
    }

    public RelatedGroupCriteriaScorer(double premium) {
        this(0.0, premium, Collections.emptyList(), false, false);
    }

    public RelatedGroupCriteriaScorer(double penalty, double premium) {
        this(penalty, premium, Collections.emptyList(), true, false);
    }

    public RelatedGroupCriteriaScorer(double penalty, double premium, Iterable<Nanoentity> allEntities) {
        this(penalty, premium, allEntities, false, true);
    }

    @Override
    public Map<EntityPair, Double> getScores(Set<CouplingInstance> instances) {
        HashMap<EntityPair, Double> result = new HashMap<EntityPair, Double>();
        for (CouplingInstance instance : instances) {
            if (this.premium != 0.0) {
                for (int i2 = 0; i2 < instance.getAllNanoentities().size() - 1; ++i2) {
                    for (int j = i2 + 1; j < instance.getAllNanoentities().size(); ++j) {
                        result.put(new EntityPair(instance.getAllNanoentities().get(i2), instance.getAllNanoentities().get(j)), this.premium);
                    }
                }
            }
            if (this.penalty != 0.0 && this.penaltyToAll) {
                this.setPenaltyToOtherFields(result, instance, this.allNanoentities);
            }
            if (this.penalty == 0.0 || !this.penaltyToOtherGroups) continue;
            List<Nanoentity> allNanoentitiesInInstances = instances.stream().flatMap(i -> i.getAllNanoentities().stream()).collect(Collectors.toList());
            this.setPenaltyToOtherFields(result, instance, allNanoentitiesInInstances);
        }
        return result;
    }

    private void setPenaltyToOtherFields(Map<EntityPair, Double> result, CouplingInstance instance, Iterable<Nanoentity> otherNanoentities) {
        for (Nanoentity groupEntity : instance.getAllNanoentities()) {
            for (Nanoentity otherEntity : otherNanoentities) {
                if (instance.getAllNanoentities().contains(otherEntity)) continue;
                result.put(new EntityPair(groupEntity, otherEntity), this.penalty);
            }
        }
    }
}

