/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.scorer.criterionScorer;

import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.InstanceType;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.criterionScorer.CriterionScorer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SemanticProximityCriterionScorer
implements CriterionScorer {
    Map<EntityPair, Double> result = new HashMap<EntityPair, Double>();
    private static final int SCORE_WRITE = 10;
    private static final int SCORE_READ = 3;
    private static final int SCORE_MIXED = 3;
    private static final int SCORE_AGGREGATION = 1;

    @Override
    public Map<EntityPair, Double> getScores(Set<CouplingInstance> instances) {
        Set<CouplingInstance> useCaseInstances = instances;
        useCaseInstances = instances.stream().filter(instance -> instance.getType().equals((Object)InstanceType.USE_CASE)).collect(Collectors.toSet());
        for (CouplingInstance instance2 : useCaseInstances) {
            List<Nanoentity> nanoentitiesWritten = instance2.getSecondNanoentities();
            List<Nanoentity> nanoentitiesRead = instance2.getNanoentities();
            this.addScoreForWriteAccess(nanoentitiesWritten);
            this.addScoreForReadAccess(nanoentitiesRead);
            this.addScoreForMixedAccess(nanoentitiesWritten, nanoentitiesRead);
        }
        List aggregationInstances = instances.stream().filter(instance -> instance.getType().equals((Object)InstanceType.AGGREGATION)).collect(Collectors.toList());
        for (CouplingInstance aggregationInstance : aggregationInstances) {
            for (Nanoentity nanoentityA : aggregationInstance.getAllNanoentities()) {
                for (Nanoentity nanoentityB : aggregationInstance.getAllNanoentities()) {
                    this.addToResult(nanoentityA, nanoentityB, 1.0);
                }
            }
        }
        this.normalizeResult(this.result);
        return this.result;
    }

    void normalizeResult(Map<EntityPair, Double> result) {
        List scores = result.values().stream().sorted((d1, d2) -> Double.compare(d2, d1)).collect(Collectors.toList());
        if (scores.isEmpty()) {
            return;
        }
        int tenPercent = Math.max(1, (int)((double)scores.size() * 0.1));
        double referenceValue = (Double)scores.get(tenPercent - 1);
        double divisor = referenceValue / 10.0;
        for (EntityPair key : result.keySet()) {
            double newScore = Math.min(10.0, result.get(key) / divisor);
            result.put(key, newScore);
        }
    }

    private void addScoreForMixedAccess(List<Nanoentity> nanoentitiesWritten, List<Nanoentity> nanoentitiesRead) {
        for (Nanoentity nanoentityWritten : nanoentitiesWritten) {
            for (Nanoentity nanoentityRead : nanoentitiesRead) {
                this.addToResult(nanoentityRead, nanoentityWritten, 3.0);
            }
        }
    }

    private void addScoreForReadAccess(List<Nanoentity> nanoentitiesRead) {
        for (int i = 0; i < nanoentitiesRead.size() - 1; ++i) {
            for (int j = i + 1; j < nanoentitiesRead.size(); ++j) {
                this.addToResult(nanoentitiesRead.get(i), nanoentitiesRead.get(j), 3.0);
            }
        }
    }

    private void addScoreForWriteAccess(List<Nanoentity> nanoentitiesWritten) {
        for (int i = 0; i < nanoentitiesWritten.size() - 1; ++i) {
            for (int j = i + 1; j < nanoentitiesWritten.size(); ++j) {
                this.addToResult(nanoentitiesWritten.get(i), nanoentitiesWritten.get(j), 10.0);
            }
        }
    }

    private void addToResult(Nanoentity nanoentityA, Nanoentity nanoentityB, double score) {
        EntityPair fieldTuple = new EntityPair(nanoentityA, nanoentityB);
        if (this.result.get(fieldTuple) == null) {
            this.result.put(fieldTuple, score);
        } else {
            this.result.put(fieldTuple, score + this.result.get(fieldTuple));
        }
    }
}

