/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.model.Service;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.solver.AbstractSolver;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graphstream.algorithm.community.Leung;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStreamSolver
extends AbstractSolver<Node, Edge> {
    private static final String WEIGHT = "weight";
    private SingleGraph graph;
    private final Logger log = LoggerFactory.getLogger(GraphStreamSolver.class);
    protected double m = 0.1;
    protected double delta = 0.05;

    public GraphStreamSolver(ServiceCutterContext context, Map<EntityPair, Map<String, Score>> scores, SolverConfiguration config) {
        super(context, scores);
        Double delta;
        this.graph = new SingleGraph("Service Cutter Graph");
        Double m = config.getAlgorithmParams().get("leungM");
        if (m != null) {
            this.log.info("parameter 'm' is {}", (Object)m);
            this.m = m;
        }
        if ((delta = config.getAlgorithmParams().get("leungDelta")) != null) {
            this.log.info("parameter 'delta' is {}", (Object)delta);
            this.delta = delta;
        }
        this.buildNodes();
        this.buildEdges();
    }

    @Override
    public SolverResult solve() {
        Leung algorithm = new Leung((Graph)this.graph, null, WEIGHT);
        algorithm.setParameters(this.m, this.delta);
        this.log.info("Using parameters m={} and delta={}", (Object)this.m, (Object)this.delta);
        algorithm.compute();
        HashMap families = new HashMap();
        for (Node node : this.graph) {
            String family = (String)node.getAttribute("ui.class");
            families.putIfAbsent(family, new ArrayList());
            ((List)families.get(family)).add(node.getId());
        }
        this.log.info("found {} families", (Object)families.keySet().size());
        char id = 'A';
        HashSet<Service> services = new HashSet<Service>();
        for (List nanoEntities : families.values()) {
            Service service = new Service();
            service.setId(id);
            service.setNanoentities(nanoEntities);
            services.add(service);
            id = this.generateNextId(id);
        }
        SolverResult solverResult = new SolverResult();
        solverResult.setServices(services);
        return solverResult;
    }

    private char generateNextId(char currentId) {
        if (currentId == 'Z') {
            return 'a';
        }
        if (currentId == 'z') {
            return '0';
        }
        if (currentId == '9') {
            throw new RuntimeException("Result produced too many services. More than 62 services currently not supported.");
        }
        currentId = (char)(currentId + '\u0001');
        return currentId;
    }

    @Override
    protected void createNode(String name) {
        this.graph.addNode(name);
    }

    @Override
    protected Node getNode(String name) {
        return this.graph.getNode(name);
    }

    @Override
    protected void createEdgeAndSetWeight(Nanoentity first, Nanoentity second, double weight) {
        String firstName = this.createNodeIdentifier(first);
        String secondName = this.createNodeIdentifier(second);
        Edge edge = this.graph.addEdge(this.createEdgeIdentifier(firstName, secondName), firstName, secondName);
        this.setWeight(edge, weight);
    }

    String createEdgeIdentifier(String firstName, String secondName) {
        return firstName + "-" + secondName;
    }

    @Override
    protected void removeEdge(Edge edge) {
        this.graph.removeEdge(edge);
    }

    @Override
    protected Edge getEdge(Nanoentity first, Nanoentity second) {
        String firstName = this.createNodeIdentifier(first);
        String secondName = this.createNodeIdentifier(second);
        return this.graph.getEdge(this.createEdgeIdentifier(firstName, secondName));
    }

    @Override
    protected Iterable<Edge> getEdges() {
        return this.graph.getEachEdge();
    }

    @Override
    protected double getWeight(Edge edge) {
        Double weight = (Double)edge.getAttribute(WEIGHT);
        return weight != null ? weight : 0.0;
    }

    @Override
    protected void setWeight(Edge edge, double weight) {
        edge.setAttribute(WEIGHT, new Object[]{weight});
    }
}

