/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizServerEngine;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.MutableGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Graphviz {
    private static final Pattern DPI_PATTERN = Pattern.compile("\"?dpi\"?\\s*=\\s*\"?([0-9.]+)\"?", 2);
    @Nullable
    private static volatile BlockingQueue<GraphvizEngine> engineQueue;
    @Nullable
    private static GraphvizEngine engine;
    private final String src;
    private final Options options;
    @Nullable
    final Rasterizer rasterizer;
    final int width;
    final int height;
    final double scale;
    final double fontAdjust;

    private Graphviz(String src, @Nullable Rasterizer rasterizer, int width, int height, double scale, double fontAdjust, Options options) {
        this.src = src;
        this.rasterizer = rasterizer;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.fontAdjust = fontAdjust;
        this.options = options;
    }

    public static void useDefaultEngines() {
        Graphviz.useEngine(new GraphvizCmdLineEngine(), new GraphvizServerEngine(), new GraphvizJdkEngine());
    }

    public static void useEngine(GraphvizEngine first, GraphvizEngine ... rest) {
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        engines.add(first);
        engines.addAll(Arrays.asList(rest));
        Graphviz.useEngine(engines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void useEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            Graphviz.useDefaultEngines();
            return;
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engineQueue == null) {
                engineQueue = new ArrayBlockingQueue<GraphvizEngine>(1);
            } else {
                try {
                    Graphviz.getEngine().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            engine = null;
            Graphviz.doUseEngine(engines);
            return;
        }
    }

    private static void doUseEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            engineQueue.add(new ErrorGraphvizEngine());
        } else {
            engines.get(0).init(e -> engineQueue.add((GraphvizEngine)e), e -> Graphviz.doUseEngine(engines.subList(1, engines.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GraphvizEngine getEngine() {
        if (engineQueue == null) {
            Graphviz.useDefaultEngines();
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine == null) {
                try {
                    engine = engineQueue.poll(120L, TimeUnit.SECONDS);
                    if (engine == null) {
                        throw new GraphvizException("Initializing graphviz engine took too long.");
                    }
                    if (engine instanceof ErrorGraphvizEngine) {
                        throw new GraphvizException("None of the provided engines could be initialized.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    public static void releaseEngine() {
        if (engine != null) {
            try {
                engine.close();
            }
            catch (Exception e) {
                throw new GraphvizException("Problem closing engine", e);
            }
        }
        engine = null;
        engineQueue = null;
    }

    public static Graphviz fromFile(File src) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            Graphviz graphviz = Graphviz.fromString(IoUtils.readStream(in)).basedir(src.getAbsoluteFile().getParentFile());
            return graphviz;
        }
    }

    public static Graphviz fromGraph(Graph graph) {
        return Graphviz.fromGraph((MutableGraph)((Object)graph));
    }

    public static Graphviz fromGraph(MutableGraph graph) {
        return Graphviz.fromString(graph.toString());
    }

    public static Graphviz fromString(String src) {
        return new Graphviz(src, Rasterizer.DEFAULT, 0, 0, 1.0, 1.0, Options.create());
    }

    public Graphviz engine(Engine engine) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.fontAdjust, this.options.engine(engine));
    }

    public Graphviz totalMemory(@Nullable Integer totalMemory) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.fontAdjust, this.options.totalMemory(totalMemory));
    }

    public Graphviz yInvert(@Nullable Boolean yInvert) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.fontAdjust, this.options.yInvert(yInvert));
    }

    public Graphviz basedir(File basedir) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.fontAdjust, this.options.basedir(basedir));
    }

    public Graphviz width(int width) {
        return new Graphviz(this.src, this.rasterizer, width, this.height, this.scale, this.fontAdjust, this.options);
    }

    public Graphviz height(int height) {
        return new Graphviz(this.src, this.rasterizer, this.width, height, this.scale, this.fontAdjust, this.options);
    }

    public Graphviz scale(double scale) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, scale, this.fontAdjust, this.options);
    }

    public Graphviz fontAdjust(double fontAdjust) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, fontAdjust, this.options);
    }

    public Renderer rasterize(@Nullable Rasterizer rasterizer) {
        if (rasterizer == null) {
            throw new IllegalArgumentException("The provided rasterizer implementation was not found. Make sure that the batik-rasterizer or svg-salamander jar is available on the classpath.");
        }
        Options opts = this.options.format(rasterizer.format());
        Graphviz graphviz = new Graphviz(this.src, rasterizer, this.width, this.height, this.scale, this.fontAdjust, opts);
        return new Renderer(graphviz, null, Format.PNG);
    }

    public Renderer render(Format format) {
        Graphviz g = new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.fontAdjust, this.options.format(format));
        return new Renderer(g, null, format);
    }

    EngineResult execute() {
        EngineResult result = this.options.format == Format.DOT ? EngineResult.fromString(this.src) : Graphviz.getEngine().execute(this.options.format.preProcess(this.src), this.options, this.rasterizer);
        return this.options.format.postProcess(this, result);
    }

    Format format() {
        return this.options.format;
    }

    double dpi() {
        Matcher matcher = DPI_PATTERN.matcher(this.src);
        return matcher.find() ? Double.parseDouble(matcher.group(1)) : 72.0;
    }

    private static class ErrorGraphvizEngine
    implements GraphvizEngine {
        private ErrorGraphvizEngine() {
        }

        @Override
        public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        }

        @Override
        public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
            return EngineResult.fromString("");
        }

        @Override
        public void close() {
        }
    }
}

