/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.ImmutablePortNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkList;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Serializer;
import guru.nidi.graphviz.model.SimpleMutableAttributed;
import guru.nidi.graphviz.model.ThrowingBiConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class MutableGraph
implements LinkSource,
LinkTarget {
    protected boolean strict;
    protected boolean directed;
    protected boolean cluster;
    protected String name;
    protected final Set<MutableNode> nodes;
    protected final Set<MutableGraph> subgraphs;
    protected final LinkList links;
    protected final MutableAttributed<MutableGraph, ForNode> nodeAttrs;
    protected final MutableAttributed<MutableGraph, ForLink> linkAttrs;
    protected final MutableAttributed<MutableGraph, ForGraph> graphAttrs;

    MutableGraph() {
        this(false, false, false, "", new LinkedHashSet<MutableNode>(), new LinkedHashSet<MutableGraph>(), new ArrayList<Link>(), null, null, null);
        CreationContext.current().ifPresent(ctx -> this.graphAttrs().add((Attributes<ForGraph>)ctx.graphAttrs()));
    }

    protected MutableGraph(boolean strict, boolean directed, boolean cluster, String name, LinkedHashSet<MutableNode> nodes, LinkedHashSet<MutableGraph> subgraphs, List<Link> links, @Nullable Attributes<? extends ForNode> nodeAttrs, @Nullable Attributes<? extends ForLink> linkAttrs, @Nullable Attributes<? extends ForGraph> graphAttrs) {
        this.strict = strict;
        this.directed = directed;
        this.cluster = cluster;
        this.name = name;
        this.nodes = nodes;
        this.subgraphs = subgraphs;
        this.links = new LinkList(this, links);
        this.nodeAttrs = new SimpleMutableAttributed<MutableGraph, ForNode>(this, nodeAttrs);
        this.linkAttrs = new SimpleMutableAttributed<MutableGraph, ForLink>(this, linkAttrs);
        this.graphAttrs = new SimpleMutableAttributed<MutableGraph, ForGraph>(this, graphAttrs);
    }

    public MutableGraph copy() {
        return new MutableGraph(this.strict, this.directed, this.cluster, this.name, new LinkedHashSet<MutableNode>(this.nodes), new LinkedHashSet<MutableGraph>(this.subgraphs), this.links, this.nodeAttrs, this.linkAttrs, this.graphAttrs);
    }

    public MutableGraph use(ThrowingBiConsumer<MutableGraph, CreationContext> actions) {
        return CreationContext.use(this, ctx -> {
            actions.accept(this, (CreationContext)ctx);
            return this;
        });
    }

    public MutableGraph setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MutableGraph setDirected(boolean directed) {
        this.directed = directed;
        return this;
    }

    public MutableGraph setCluster(boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    public MutableGraph setName(String name) {
        this.name = name;
        return this;
    }

    public MutableGraph add(LinkSource ... sources) {
        return this.add(Arrays.asList(sources));
    }

    public MutableGraph add(List<? extends LinkSource> sources) {
        for (LinkSource linkSource : sources) {
            this.add(linkSource);
        }
        return this;
    }

    public MutableGraph add(LinkSource source) {
        source.addTo(this);
        return this;
    }

    public MutableGraph addLink(LinkTarget ... targets) {
        for (LinkTarget target : targets) {
            this.addLink(target);
        }
        return this;
    }

    public MutableGraph addLink(LinkTarget target) {
        this.links.add(this.linkTo(target));
        return this;
    }

    @Override
    public Link linkTo(LinkTarget target) {
        Link link = target.linkTo();
        return Link.between(this, link.to).with(link.attributes);
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    @Override
    public void addTo(MutableGraph graph) {
        graph.subgraphs.add(this);
    }

    @Override
    public LinkTarget asLinkTarget() {
        return this;
    }

    @Override
    public LinkSource asLinkSource() {
        return this;
    }

    public Collection<MutableNode> rootNodes() {
        return this.nodes;
    }

    public Collection<MutableNode> nodes() {
        HashSet<MutableNode> ns = new HashSet<MutableNode>();
        for (MutableNode node : this.nodes) {
            this.collectNodes(node, ns);
        }
        return ns;
    }

    private void collectNodes(MutableNode node, Set<MutableNode> visited) {
        if (!visited.contains(node)) {
            visited.add(node);
            for (Link link : node.links()) {
                if (!(link.to instanceof ImmutablePortNode)) continue;
                this.collectNodes(((ImmutablePortNode)link.to).node(), visited);
            }
        }
    }

    public Collection<MutableGraph> graphs() {
        return this.subgraphs;
    }

    @Override
    public List<Link> links() {
        return this.links;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public String name() {
        return this.name;
    }

    public MutableAttributed<MutableGraph, ForNode> nodeAttrs() {
        return this.nodeAttrs;
    }

    public MutableAttributed<MutableGraph, ForLink> linkAttrs() {
        return this.linkAttrs;
    }

    public MutableAttributed<MutableGraph, ForGraph> graphAttrs() {
        return this.graphAttrs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableGraph that = (MutableGraph)o;
        return this.strict == that.strict && this.directed == that.directed && this.cluster == that.cluster && Objects.equals(this.name, that.name) && Objects.equals(this.nodes, that.nodes) && Objects.equals(this.subgraphs, that.subgraphs) && Objects.equals(this.links, that.links) && Objects.equals(this.nodeAttrs, that.nodeAttrs) && Objects.equals(this.linkAttrs, that.linkAttrs) && Objects.equals(this.graphAttrs, that.graphAttrs);
    }

    public int hashCode() {
        return Objects.hash(this.strict, this.directed, this.cluster, this.name, this.nodes, this.subgraphs, this.links, this.nodeAttrs, this.linkAttrs, this.graphAttrs);
    }

    public String toString() {
        return new Serializer(this).serialize();
    }
}

