/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.ImmutablePortNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkList;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Port;
import guru.nidi.graphviz.model.PortNode;
import guru.nidi.graphviz.model.PortSource;
import guru.nidi.graphviz.model.SimpleMutableAttributed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MutableNode
implements MutableAttributed<MutableNode, ForNode>,
LinkSource,
LinkTarget {
    protected Label name;
    protected final LinkList links;
    protected final MutableAttributed<MutableNode, ForNode> attributes;

    MutableNode(Label name) {
        this(name, new ArrayList<Link>(), Attributes.attrs());
    }

    protected MutableNode(Label name, List<Link> links, Attributes<? extends ForNode> attributes) {
        this.links = new LinkList(this, links);
        this.attributes = new SimpleMutableAttributed<MutableNode, ForNode>(this, attributes);
        this.name = name;
        this.setName(name);
    }

    public MutableNode copy() {
        return new MutableNode(this.name, this.links, this.attributes.copy());
    }

    public final MutableNode setName(Label name) {
        this.name = name;
        if (name.isExternal()) {
            this.name = Label.of("");
            this.attributes.add(name);
        } else if (name.isHtml()) {
            this.attributes.add(name);
        }
        return this;
    }

    public MutableNode setName(String name) {
        return this.setName(Label.of(name));
    }

    MutableNode merge(MutableNode n) {
        this.links.addAll(n.links);
        this.attributes.add((Attributes<ForNode>)n.attributes);
        return this;
    }

    public PortNode port(@Nullable String record) {
        return this.port(record, null);
    }

    public PortNode port(@Nullable Compass compass) {
        return this.port(null, compass);
    }

    public PortNode port(@Nullable String record, @Nullable Compass compass) {
        return new ImmutablePortNode(this, new Port(record, compass));
    }

    @Override
    public Link linkTo(LinkTarget target) {
        return this.adjustLink(target.linkTo());
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    public MutableNode addLink(LinkTarget target) {
        this.links.add(this.linkTo(target));
        return this;
    }

    public MutableNode addLink(LinkTarget ... targets) {
        return this.addLink(Arrays.asList(targets));
    }

    public MutableNode addLink(List<? extends LinkTarget> targets) {
        for (LinkTarget linkTarget : targets) {
            this.addLink(linkTarget);
        }
        return this;
    }

    public MutableNode addLink(String node) {
        return this.addLink((LinkTarget)Factory.mutNode(node));
    }

    public MutableNode addLink(String ... nodes) {
        for (String node : nodes) {
            this.addLink(node);
        }
        return this;
    }

    @Override
    public LinkTarget asLinkTarget() {
        return this;
    }

    @Override
    public LinkSource asLinkSource() {
        return this;
    }

    @Override
    public MutableNode add(Attributes<? extends ForNode> attrs) {
        this.attributes.add((Attributes<ForNode>)attrs);
        return this;
    }

    @Override
    public void addTo(MutableGraph graph) {
        graph.nodes.add(this);
    }

    @Override
    public Attributes<? super ForNode> applyTo(MapAttributes<? super ForNode> attrs) {
        return this.attributes.applyTo(attrs);
    }

    @Override
    public Object get(String key) {
        return this.attributes.get(key);
    }

    private Link adjustLink(Link link) {
        if (link.from == null) {
            return Link.between(this, link.to).with(link.attributes);
        }
        if (link.from instanceof ImmutablePortNode) {
            ImmutablePortNode f = (ImmutablePortNode)link.from;
            return f.node().name.equals(this.name) ? Link.between(new ImmutablePortNode(this, f.port()), link.to).with(link.attributes) : Link.between(this, link.from.asLinkTarget());
        }
        if (link.from instanceof PortSource) {
            PortSource f = (PortSource)link.from;
            return Link.between(new ImmutablePortNode(this, f.port), link.to).with(link.attributes);
        }
        if (link.from instanceof MutableNode) {
            return ((MutableNode)link.from).name.equals(this.name) ? Link.between(this, link.to).with(link.attributes) : Link.between(this, link.from.asLinkTarget());
        }
        throw new IllegalStateException("Unexpected element " + link.from + " in link");
    }

    public Label name() {
        return this.name;
    }

    @Override
    public List<Link> links() {
        return this.links;
    }

    public MutableAttributed<MutableNode, ForNode> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNode entries = (MutableNode)o;
        return Objects.equals(this.name, entries.name) && Objects.equals(this.links, entries.links) && Objects.equals(this.attributes, entries.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.links, this.attributes);
    }

    public String toString() {
        return this.name + this.attributes.toString() + "->" + this.links.stream().map(l -> l.to.toString()).collect(Collectors.joining(","));
    }
}

