/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.contextmap.generator;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.contextmapper.contextmap.generator.model.ContextMap;
import org.contextmapper.contextmap.generator.model.DownstreamPatterns;
import org.contextmapper.contextmap.generator.model.Partnership;
import org.contextmapper.contextmap.generator.model.SharedKernel;
import org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship;
import org.contextmapper.contextmap.generator.model.UpstreamPatterns;

public class ContextMapGenerator {
    private static final String EDGE_SPACING_UNIT = "        ";
    private Map<String, MutableNode> bcNodesMap;
    protected int labelSpacingFactor = 1;
    protected int height = 1000;
    protected int width = 2000;
    protected boolean useHeight = false;
    protected boolean useWidth = true;

    public ContextMapGenerator setLabelSpacingFactor(int spacingFactor) {
        this.labelSpacingFactor = spacingFactor < 1 ? 1 : (spacingFactor > 20 ? 20 : spacingFactor);
        return this;
    }

    public ContextMapGenerator setHeight(int height) {
        this.useHeight = true;
        this.useWidth = false;
        this.height = height;
        return this;
    }

    public ContextMapGenerator setWidth(int width) {
        this.useWidth = true;
        this.useHeight = false;
        this.width = width;
        return this;
    }

    public void generateContextMapGraphic(ContextMap contextMap, Format format, String fileName) throws IOException {
        MutableGraph graph = this.createGraph(contextMap);
        if (this.useWidth) {
            Graphviz.fromGraph(graph).width(this.width).render(format).toFile(new File(fileName));
        } else {
            Graphviz.fromGraph(graph).height(this.height).render(format).toFile(new File(fileName));
        }
    }

    public void generateContextMapGraphic(ContextMap contextMap, Format format, OutputStream outputStream) throws IOException {
        MutableGraph graph = this.createGraph(contextMap);
        if (this.useWidth) {
            Graphviz.fromGraph(graph).width(this.width).render(format).toOutputStream(outputStream);
        } else {
            Graphviz.fromGraph(graph).height(this.height).render(format).toOutputStream(outputStream);
        }
    }

    private MutableGraph createGraph(ContextMap contextMap) {
        this.bcNodesMap = new TreeMap<String, MutableNode>();
        MutableGraph graph = Factory.mutGraph("ContextMapGraph");
        contextMap.getBoundedContexts().forEach(bc -> {
            MutableNode node = Factory.mutNode(bc.getName());
            node.add((Attributes)Label.lines(bc.getName()));
            node.add((Attributes)Shape.EGG);
            node.add(Attributes.attr("margin", "0.3"));
            node.add(Attributes.attr("orientation", this.orientationDegree()));
            node.add(Attributes.attr("fontname", "sans-serif"));
            node.add(Attributes.attr("fontsize", "16"));
            node.add(Attributes.attr("style", "bold"));
            this.bcNodesMap.put(bc.getName(), node);
        });
        contextMap.getRelationships().forEach(rel -> {
            MutableNode node1 = this.bcNodesMap.get(rel.getFirstParticipant().getName());
            MutableNode node2 = this.bcNodesMap.get(rel.getSecondParticipant().getName());
            if (rel instanceof Partnership) {
                node1.addLink((LinkTarget)((Link)Factory.to(node2).with((Attributes)this.createLabel("Partnership"))).add(Attributes.attr("fontname", "sans-serif")).add(Attributes.attr("style", "bold")).add(Attributes.attr("fontsize", "12")));
            } else if (rel instanceof SharedKernel) {
                node1.addLink((LinkTarget)((Link)Factory.to(node2).with((Attributes)this.createLabel("Shared Kernel"))).add(Attributes.attr("fontname", "sans-serif")).add(Attributes.attr("style", "bold")).add(Attributes.attr("fontsize", "12")));
            } else {
                UpstreamDownstreamRelationship upDownRel = (UpstreamDownstreamRelationship)rel;
                node1.addLink((LinkTarget)Factory.to(node2).with(this.createLabel(upDownRel.isCustomerSupplier() ? "Customer/Supplier" : ""), Attributes.attr("labeldistance", "0"), Attributes.attr("fontname", "sans-serif"), Attributes.attr("fontsize", "12"), Attributes.attr("style", "bold"), Attributes.attr("headlabel", this.getEdgeHTMLLabel("D", this.downstreamPatternsToStrings(upDownRel.getDownstreamPatterns()))), Attributes.attr("taillabel", this.getEdgeHTMLLabel("U", this.upstreamPatternsToStrings(upDownRel.getUpstreamPatterns())))));
            }
        });
        for (MutableNode node : this.bcNodesMap.values()) {
            graph.add((LinkSource)node);
        }
        return graph;
    }

    private Label createLabel(String label) {
        if (!"".equals(label)) {
            return Label.of(label);
        }
        String spacing = "";
        for (int i = 1; i <= this.labelSpacingFactor; ++i) {
            spacing = spacing + EDGE_SPACING_UNIT;
        }
        return Label.of(spacing);
    }

    private int orientationDegree() {
        return new Random().nextInt(350);
    }

    private Set<String> downstreamPatternsToStrings(Set<DownstreamPatterns> patterns) {
        return patterns.stream().map(p -> p.toString()).collect(Collectors.toSet());
    }

    private Set<String> upstreamPatternsToStrings(Set<UpstreamPatterns> patterns) {
        return patterns.stream().map(p -> p.toString()).collect(Collectors.toSet());
    }

    private Label getEdgeHTMLLabel(String upstreamDownstreamLabel, Set<String> patterns) {
        String upstreamDownstreamCell = "<td bgcolor=\"white\">" + upstreamDownstreamLabel + "</td>";
        String patternCell = "";
        String border = "0";
        if (patterns.size() > 0) {
            upstreamDownstreamCell = "<td bgcolor=\"white\" sides=\"r\">" + upstreamDownstreamLabel + "</td>";
            patternCell = "<td sides=\"trbl\" bgcolor=\"white\"><font>" + String.join((CharSequence)", ", patterns) + "</font></td>";
            border = "1";
        }
        return Label.html("<table cellspacing=\"0\" cellborder=\"" + border + "\" border=\"0\">\n<tr>" + upstreamDownstreamCell + patternCell + "</tr>\n</table>");
    }
}

