/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.contextmap.generator.model;

import java.util.HashSet;
import java.util.Set;
import org.contextmapper.contextmap.generator.model.BoundedContext;
import org.contextmapper.contextmap.generator.model.Relationship;
import org.contextmapper.contextmap.generator.model.exception.BoundedContextAlreadyPartOfContextMapException;
import org.contextmapper.contextmap.generator.model.exception.BoundedContextNotPartOfContextMapException;

public class ContextMap {
    private Set<BoundedContext> boundedContexts = new HashSet<BoundedContext>();
    private Set<Relationship> relationships = new HashSet<Relationship>();

    public ContextMap addBoundedContext(BoundedContext boundedContext) {
        if (this.boundedContexts.contains(boundedContext)) {
            throw new BoundedContextAlreadyPartOfContextMapException(boundedContext.getName());
        }
        this.boundedContexts.add(boundedContext);
        return this;
    }

    public ContextMap addRelationship(Relationship relationship) {
        if (!this.boundedContexts.contains(relationship.getFirstParticipant())) {
            throw new BoundedContextNotPartOfContextMapException(relationship.getFirstParticipant());
        }
        if (!this.boundedContexts.contains(relationship.getSecondParticipant())) {
            throw new BoundedContextNotPartOfContextMapException(relationship.getSecondParticipant());
        }
        this.relationships.add(relationship);
        return this;
    }

    public Set<BoundedContext> getBoundedContexts() {
        HashSet<BoundedContext> set = new HashSet<BoundedContext>();
        set.addAll(this.boundedContexts);
        return set;
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.addAll(this.relationships);
        return set;
    }
}

