@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  context-mapper-lsp startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and CONTEXT_MAPPER_LSP_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\context-mapper-lsp-5.9.0.jar;%APP_HOME%\lib\context-mapper-dsl-5.9.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.ide-2.20.0.jar;%APP_HOME%\lib\org.eclipse.xtext.ide-2.20.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase-2.20.0.jar;%APP_HOME%\lib\org.eclipse.xtext.common.types-2.20.0.jar;%APP_HOME%\lib\org.eclipse.xtext-2.20.0.jar;%APP_HOME%\lib\commons-io-2.6.jar;%APP_HOME%\lib\freemarker-2.3.22.jar;%APP_HOME%\lib\service-cutter-library-1.1.4.jar;%APP_HOME%\lib\jackson-databind-2.9.9.jar;%APP_HOME%\lib\jackson-annotations-2.9.9.jar;%APP_HOME%\lib\henshin-interpreter-1.4.0.jar;%APP_HOME%\lib\context-map-generator-1.0.1.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.change-2.11.0.jar;%APP_HOME%\lib\org.eclipse.lsp4j-0.8.1.jar;%APP_HOME%\lib\org.eclipse.xtext.util-2.20.0.jar;%APP_HOME%\lib\org.eclipse.lsp4j.generator-0.8.1.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.20.0.jar;%APP_HOME%\lib\slf4j-log4j12-1.7.28.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\org.eclipse.debug.core-3.13.0.jar;%APP_HOME%\lib\org.eclipse.core.resources-3.13.600.jar;%APP_HOME%\lib\org.eclipse.core.variables-3.4.700.jar;%APP_HOME%\lib\org.eclipse.core.expressions-3.6.600.jar;%APP_HOME%\lib\org.eclipse.core.runtime-3.17.0.jar;%APP_HOME%\lib\org.eclipse.core.filesystem-1.7.600.jar;%APP_HOME%\lib\org.eclipse.core.jobs-3.10.600.jar;%APP_HOME%\lib\org.eclipse.core.contenttype-3.7.500.jar;%APP_HOME%\lib\org.eclipse.equinox.app-1.4.300.jar;%APP_HOME%\lib\org.eclipse.equinox.registry-3.8.600.jar;%APP_HOME%\lib\org.eclipse.equinox.preferences-3.7.600.jar;%APP_HOME%\lib\org.eclipse.equinox.common-3.10.500.jar;%APP_HOME%\lib\org.eclipse.osgi-3.15.0.jar;%APP_HOME%\lib\org.eclipse.emf.common-2.12.0.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.xmi-2.12.0.jar;%APP_HOME%\lib\guice-3.0.jar;%APP_HOME%\lib\antlr-runtime-3.2.jar;%APP_HOME%\lib\jackson-core-2.9.9.jar;%APP_HOME%\lib\org.eclipse.emf.ecore-2.12.0.jar;%APP_HOME%\lib\commons-lang3-3.9.jar;%APP_HOME%\lib\svgSalamander-1.1.2.jar;%APP_HOME%\lib\commons-exec-1.3.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.20.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.20.0.jar;%APP_HOME%\lib\guava-28.1-jre.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\slf4j-api-1.7.28.jar;%APP_HOME%\lib\gs-algo-1.3.jar;%APP_HOME%\lib\gs-core-1.3.jar;%APP_HOME%\lib\org.eclipse.lsp4j.jsonrpc-0.8.1.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\asm-commons-7.2.jar;%APP_HOME%\lib\classgraph-4.8.35.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\pherd-1.0.jar;%APP_HOME%\lib\mbox2-1.0.jar;%APP_HOME%\lib\commons-math-2.1.jar;%APP_HOME%\lib\commons-math3-3.4.1.jar;%APP_HOME%\lib\jfreechart-1.0.14.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\checker-qual-2.8.1.jar;%APP_HOME%\lib\error_prone_annotations-2.3.2.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.18.jar;%APP_HOME%\lib\gson-2.8.2.jar;%APP_HOME%\lib\asm-analysis-7.2.jar;%APP_HOME%\lib\asm-tree-7.2.jar;%APP_HOME%\lib\asm-7.2.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\jcommon-1.0.17.jar;%APP_HOME%\lib\xml-apis-1.3.04.jar;%APP_HOME%\lib\itext-2.1.5.jar;%APP_HOME%\lib\bcmail-jdk14-138.jar;%APP_HOME%\lib\bcprov-jdk14-138.jar

@rem Execute context-mapper-lsp
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CONTEXT_MAPPER_LSP_OPTS%  -classpath "%CLASSPATH%" org.eclipse.xtext.ide.server.ServerLauncher %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CONTEXT_MAPPER_LSP_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CONTEXT_MAPPER_LSP_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
