/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Evolution implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    GENESIS(1, "GENESIS", "GENESIS"),
    CUSTOM_BUILT(2, "CUSTOM_BUILT", "CUSTOM_BUILT"),
    PRODUCT(3, "PRODUCT", "PRODUCT"),
    COMMODITY(4, "COMMODITY", "COMMODITY");

    public static final int UNDEFINED_VALUE = 0;
    public static final int GENESIS_VALUE = 1;
    public static final int CUSTOM_BUILT_VALUE = 2;
    public static final int PRODUCT_VALUE = 3;
    public static final int COMMODITY_VALUE = 4;
    private static final Evolution[] VALUES_ARRAY;
    public static final List<Evolution> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Evolution get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Evolution result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Evolution getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Evolution result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Evolution get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return GENESIS;
            }
            case 2: {
                return CUSTOM_BUILT;
            }
            case 3: {
                return PRODUCT;
            }
            case 4: {
                return COMMODITY;
            }
        }
        return null;
    }

    private Evolution(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Evolution[]{UNDEFINED, GENESIS, CUSTOM_BUILT, PRODUCT, COMMODITY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

