/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.AssociationInfo;
import org.contextmapper.dsl.generator.plantuml.AssociationLink;
import org.contextmapper.dsl.generator.plantuml.ClassRelationType;
import org.contextmapper.dsl.generator.plantuml.Multiplicity;
import org.contextmapper.dsl.generator.plantuml.UMLRelationship;
import org.contextmapper.tactic.dsl.tacticdsl.Association;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObjectOperation;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.Event;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractPlantUMLClassDiagramCreator<T extends EObject>
extends AbstractPlantUMLDiagramCreator<T> {
    protected Map<AssociationLink, AssociationInfo> associationInfos;
    protected List<UMLRelationship> extensions;
    protected List<SimpleDomainObject> domainObjects;

    protected void printDomainObject(SimpleDomainObject domainObject, int indentation) {
        this.printDomainObject(null, domainObject, indentation);
    }

    protected void printDomainObject(Aggregate aggregate, SimpleDomainObject domainObject, int indentation) {
        if (domainObject instanceof Enum) {
            this.printEnum((Enum)domainObject, indentation);
        } else if (domainObject instanceof Entity) {
            this.printEntity(aggregate, (Entity)domainObject, indentation);
        } else if (domainObject instanceof Event) {
            this.printEvent(aggregate, (Event)domainObject, indentation);
        } else if (domainObject instanceof ValueObject) {
            this.printValueObject(aggregate, (ValueObject)domainObject, indentation);
        }
    }

    protected void printModule(SculptorModule module) {
        this.sb.append("package ");
        if (module.getBasePackage() != null && !"".equals(module.getBasePackage())) {
            this.sb.append(module.getBasePackage()).append(".").append(module.getName());
        } else {
            this.sb.append(module.getName());
        }
        this.sb.append(" {");
        this.linebreak();
        for (Aggregate aggregate : module.getAggregates()) {
            this.printAggregate(aggregate, 1);
        }
        for (SimpleDomainObject simpleDomainObject : module.getDomainObjects()) {
            this.printDomainObject(simpleDomainObject, 1);
        }
        for (Service service : module.getServices()) {
            this.printService(service, 1);
        }
        this.sb.append("}");
        this.linebreak();
    }

    protected void printAggregate(Aggregate aggregate, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("package ").append("\"'").append(aggregate.getName()).append("' ").append("Aggregate\"").append(" <<Rectangle>> ").append("{");
        this.linebreak();
        for (SimpleDomainObject domainObject : aggregate.getDomainObjects()) {
            this.printDomainObject(aggregate, domainObject, indentation + 1);
        }
        for (Service service : aggregate.getServices()) {
            this.printService(aggregate, service, indentation + 1);
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    protected void printService(Service service, int indentation) {
        this.printService(null, service, indentation);
    }

    protected void printService(Aggregate aggregate, Service service, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("class").append(" ").append(service.getName());
        this.sb.append(" <<(S,DarkSeaGreen) Service>> ");
        this.sb.append("{");
        this.linebreak();
        this.printServiceOperations(service.getName(), (List<ServiceOperation>)service.getOperations(), indentation + 1);
        this.processAssociations(aggregate, service.getName(), (List<Association>)service.getAssociations());
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printServiceOperations(String objectName, List<ServiceOperation> operations, int indentation) {
        for (ServiceOperation operation : operations) {
            this.printOperation(objectName, operation.getName(), operation.getReturnType(), (List<Parameter>)operation.getParameters(), indentation);
        }
    }

    private void printEnum(Enum theEnum, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("enum").append(" ").append(theEnum.getName()).append(" {");
        this.linebreak();
        for (EnumValue value : theEnum.getValues()) {
            this.printIndentation(indentation + 1);
            this.sb.append(value.getName());
            this.linebreak();
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printEntity(Aggregate aggregate, Entity entity, int indentation) {
        this.printStereotypedClass(aggregate, "(E,DarkSeaGreen) Entity", entity, indentation);
    }

    private void printValueObject(Aggregate aggregate, ValueObject valueObject, int indentation) {
        this.printStereotypedClass(aggregate, "(V,DarkSeaGreen) Value Object", valueObject, indentation);
    }

    private void printEvent(Aggregate aggregate, Event event, int indentation) {
        if (event instanceof CommandEvent) {
            this.printStereotypedClass(aggregate, "(C,#3bc5e9) Command", event, indentation);
        } else if (event instanceof DomainEvent) {
            this.printStereotypedClass(aggregate, "(E,#ff9f4b) Domain Event", event, indentation);
        }
    }

    private void printStereotypedClass(Aggregate aggregate, String stereotype, DomainObject object, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("class").append(" ").append(object.getName());
        if (object.isAggregateRoot()) {
            this.sb.append(" <<(A,#fffab8) Aggregate Root>> ");
        } else {
            this.sb.append(" <<" + stereotype + ">> ");
        }
        this.sb.append("{");
        this.linebreak();
        this.printAttributes((List<Attribute>)object.getAttributes(), indentation + 1);
        this.printReferenceAttributes((List<Reference>)object.getReferences(), indentation + 1);
        this.processReferencesAsAssociations(aggregate, object, (List<Reference>)object.getReferences());
        this.printDomainObjectOperations(object.getName(), (List<DomainObjectOperation>)object.getOperations(), indentation + 1);
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
        this.processAssociations(aggregate, object.getName(), (List<Association>)object.getAssociations());
        if (object.getExtendsName() != null && !"".equals(object.getExtendsName())) {
            this.addExtensionToList(object.getName(), object.getExtendsName());
        } else if (object instanceof Entity && ((Entity)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((Entity)object).getExtends());
        } else if (object instanceof CommandEvent && ((CommandEvent)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((CommandEvent)object).getExtends());
        } else if (object instanceof DomainEvent && ((DomainEvent)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((DomainEvent)object).getExtends());
        } else if (object instanceof ValueObject && ((ValueObject)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((ValueObject)object).getExtends());
        }
    }

    private void processAssociations(Aggregate aggregate, String source, List<Association> associations) {
        for (Association association : associations) {
            this.addAssociationToList(aggregate, source, association.getDomainObjectType(), association.getDescription());
        }
    }

    private void processReferencesAsAssociations(Aggregate aggregate, SimpleDomainObject sourceDomainObject, List<Reference> references) {
        for (Reference reference : references) {
            Multiplicity multiplicityTarget = this.getMultiplicityReference(reference);
            this.addNavigableAssociationToList(aggregate, sourceDomainObject.getName(), reference.getDomainObjectType(), this.getLabel(reference.getAssociationLabel(), reference.getName()), multiplicityTarget);
        }
    }

    private Multiplicity getMultiplicityReference(Reference reference) {
        Multiplicity result = new Multiplicity(1, 1);
        if (reference.getCollectionType() != null && reference.getCollectionType() != CollectionType.NONE) {
            result = new Multiplicity(0, Multiplicity.STAR);
        }
        if (reference.getSize() != null && !reference.getSize().equals("")) {
            String[] parts;
            String size = reference.getSize();
            for (String part : parts = size.split(",")) {
                Integer max;
                Integer min;
                if (part.startsWith("min=") && (min = this.parseIntLax(part.substring(4))) != null) {
                    result = result.withMin(min);
                }
                if (!part.startsWith("max=") || (max = this.parseIntLax(part.substring(4))) == null) continue;
                result = result.withMax(max);
            }
        }
        if (reference.isNullable()) {
            result = result.withMin(0);
        }
        return result;
    }

    private Integer parseIntLax(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String getLabel(String label, String name) {
        if (label != null && !"".equals(label)) {
            return label;
        }
        return name;
    }

    private void addNavigableAssociationToList(Aggregate aggregate, String source, SimpleDomainObject targetDomainObject, String label, Multiplicity multiplicityTarget) {
        if (this.domainObjects.contains(targetDomainObject)) {
            String target = targetDomainObject.getName();
            AssociationInfo info = this.createOrGetAssociationInList(aggregate, source, target, label);
            info.setNavigability(source, target);
            if (info.getMultiplicity(source) == null) {
                info.setMultiplicity(source, new Multiplicity(1, 1));
            }
            if (info.getMultiplicity(target) == null || info.getMultiplicity(target).getMin() == 1) {
                info.setMultiplicity(target, multiplicityTarget);
            }
        }
    }

    private void addAssociationToList(Aggregate aggregate, String source, SimpleDomainObject targetDomainObject, String label) {
        if (this.domainObjects.contains(targetDomainObject)) {
            String target = targetDomainObject.getName();
            this.createOrGetAssociationInList(aggregate, source, target, label);
        }
    }

    private AssociationInfo createOrGetAssociationInList(Aggregate aggregate, String source, String target, String label) {
        AssociationLink link = new AssociationLink(source, target, label);
        if (!this.associationInfos.containsKey(link)) {
            AssociationInfo info = new AssociationInfo(link);
            if (this.aggregateContainsDomainObject(aggregate, source)) {
                info.setAggregateSource(aggregate.getName());
            }
            if (this.aggregateContainsDomainObject(aggregate, target)) {
                info.setAggregateTarget(aggregate.getName());
            }
            this.associationInfos.put(link, info);
        }
        return this.associationInfos.get(link);
    }

    private boolean aggregateContainsDomainObject(Aggregate aggregate, String source) {
        if (aggregate != null) {
            return aggregate.getDomainObjects().stream().filter(obj -> obj.getName().equals(source)).findAny().isPresent();
        }
        return false;
    }

    private void addExtensionToList(String sourceDomainObject, SimpleDomainObject extendedDomainObject) {
        if (this.domainObjects.contains(extendedDomainObject)) {
            this.addExtensionToList(sourceDomainObject, extendedDomainObject.getName());
        }
    }

    private void addExtensionToList(String sourceDomainObject, String extendedDomainObject) {
        UMLRelationship relationship = new UMLRelationship(sourceDomainObject, extendedDomainObject, "", ClassRelationType.EXTENSION);
        if (!this.extensions.contains(relationship)) {
            this.extensions.add(relationship);
        }
    }

    private void printAttributes(List<Attribute> attributes, int indentation) {
        for (Attribute attribute : attributes) {
            this.printIndentation(indentation);
            this.sb.append(this.getAttributeTypeAsString(attribute));
            this.sb.append(" ").append(attribute.getName());
            this.linebreak();
        }
    }

    private void printDomainObjectOperations(String objectName, List<DomainObjectOperation> operations, int indentation) {
        for (DomainObjectOperation operation : operations) {
            this.printOperation(objectName, operation.getName(), operation.getReturnType(), (List<Parameter>)operation.getParameters(), indentation);
        }
    }

    private String getAttributeTypeAsString(Attribute attribute) {
        Object type = attribute.getType();
        if (attribute.getCollectionType() != CollectionType.NONE) {
            type = attribute.getCollectionType() + "<" + attribute.getType() + ">";
        }
        if (attribute.isNullable()) {
            type = (String)type + "[0..1]";
        }
        return type;
    }

    private void printReferenceAttributes(List<Reference> references, int indentation) {
        for (Reference reference : references) {
            this.printIndentation(indentation);
            this.sb.append(this.getReferenceTypeAsString(reference));
            if (reference.isNullable()) {
                this.sb.append("[0..1]");
            }
            this.sb.append(" ").append(reference.getName());
            this.linebreak();
        }
    }

    protected void printOperation(String objectName, String operationName, ComplexType returnType, List<Parameter> parameters, int indentation) {
        this.printIndentation(indentation);
        String returnTypeAsString = returnType == null ? "void" : this.getComplexMethodTypeAsString(returnType);
        this.sb.append(returnTypeAsString).append(" ").append(operationName).append("(");
        ArrayList parameterStrings = Lists.newArrayList();
        for (Parameter parameter : parameters) {
            String parameterType = this.getComplexMethodTypeAsString(parameter.getParameterType());
            parameterStrings.add(parameterType + " " + parameter.getName());
        }
        if (!parameterStrings.isEmpty()) {
            this.sb.append(String.join((CharSequence)", ", parameterStrings));
        }
        this.sb.append(")");
        this.linebreak();
    }

    private String getComplexMethodTypeAsString(ComplexType type) {
        String genericType = "Object";
        genericType = type.getDomainObjectType() != null ? type.getDomainObjectType().getName() : type.getType();
        if (type.getCollectionType() != CollectionType.NONE) {
            return type.getCollectionType().getName() + "<" + genericType + ">";
        }
        return genericType;
    }

    private String getReferenceTypeAsString(Reference reference) {
        if (reference.getCollectionType() != CollectionType.NONE) {
            return reference.getCollectionType().getName() + "<" + reference.getDomainObjectType().getName() + ">";
        }
        return reference.getDomainObjectType().getName();
    }

    protected void printReferences(int indentation) {
        this.associationInfos.forEach((link, info) -> {
            boolean suppressMultiplicity = info.getMultiplicityFirstParticipant() != null && info.getMultiplicityFirstParticipant().isConstant(1) && info.getMultiplicitySecondParticipant() != null && info.getMultiplicitySecondParticipant().isConstant(1);
            this.printIndentation(indentation);
            this.sb.append(link.getFirstParticipant()).append(" ");
            if (info.getMultiplicityFirstParticipant() != null && !suppressMultiplicity) {
                this.sb.append("\"").append(this.printMultiplicity(info.getMultiplicityFirstParticipant())).append("\"").append(" ");
            }
            this.printLink((AssociationInfo)info);
            if (info.getMultiplicitySecondParticipant() != null && !suppressMultiplicity) {
                this.sb.append("\"").append(this.printMultiplicity(info.getMultiplicitySecondParticipant())).append("\"").append(" ");
            }
            this.sb.append(link.getSecondParticipant());
            if (!"".equals(link.getLabel())) {
                this.sb.append(" : ").append(link.getLabel());
            }
            this.linebreak();
        });
        for (UMLRelationship extension : this.extensions) {
            this.printIndentation(indentation);
            this.sb.append(extension.getSource()).append(" ").append(extension.getSymbol()).append(" ").append(extension.getTarget());
            this.linebreak();
        }
    }

    private void printLink(AssociationInfo info) {
        String aggregationSymbol;
        boolean multFirstIsMany = info.getMultiplicityFirstParticipant() != null && info.getMultiplicityFirstParticipant().getMax() > 1;
        boolean multSecondIsMany = info.getMultiplicitySecondParticipant() != null && info.getMultiplicitySecondParticipant().getMax() > 1;
        String string = aggregationSymbol = info.getAggregateSource() != null && info.getAggregateSource().equals(info.getAggregateTarget()) ? "*" : "o";
        if (multSecondIsMany && !multFirstIsMany) {
            this.sb.append(aggregationSymbol);
        } else if (info.getIsFirstNavigableFromSecond()) {
            this.sb.append("<");
        }
        this.sb.append("--");
        if (multFirstIsMany && !multSecondIsMany) {
            this.sb.append(aggregationSymbol);
        } else if (info.getIsSecondNavigableFromFirst()) {
            this.sb.append(">");
        }
        this.sb.append(" ");
    }

    private String printMultiplicity(Multiplicity multiplicity) {
        int max;
        int min = multiplicity.getMin();
        if (min == (max = multiplicity.getMax())) {
            return Integer.toString(min);
        }
        if (min == 0 && max == Multiplicity.STAR) {
            return "*";
        }
        return Integer.toString(min) + ".." + Integer.toString(max);
    }

    protected void printIndentation(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.sb.append("\t");
        }
    }
}

