/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;

public class RefactoringHelper {
    private AbstractRefactoring ar;

    public RefactoringHelper(AbstractRefactoring ar) {
        this.ar = ar;
    }

    public void adjustAggregateAndModuleNames(BoundedContext bc, String suffix) {
        Set<String> allAggregateNames = this.collectAllAggregateNames();
        Set<String> allModuleNames = this.collectAllModuleNames();
        for (Aggregate aggregate : bc.getAggregates()) {
            aggregate.setName(this.getUniqueName(aggregate.getName() + suffix, allAggregateNames));
            this.adjustDomainObjectNames((List<SimpleDomainObject>)aggregate.getDomainObjects(), suffix);
        }
        for (SculptorModule module : bc.getModules()) {
            module.setName(this.getUniqueName(module.getName() + suffix, allModuleNames));
            this.adjustDomainObjectNames((List<SimpleDomainObject>)module.getDomainObjects(), suffix);
            for (Aggregate aggregate : module.getAggregates()) {
                aggregate.setName(this.getUniqueName(aggregate.getName() + suffix, allAggregateNames));
                this.adjustDomainObjectNames((List<SimpleDomainObject>)aggregate.getDomainObjects(), suffix);
            }
        }
    }

    public void adjustDomainObjectNames(List<SimpleDomainObject> domainObjects, String suffix) {
        for (SimpleDomainObject simpleDO : domainObjects) {
            simpleDO.setName(simpleDO.getName() + suffix);
        }
    }

    public Set<String> collectAllAggregateNames() {
        HashSet aggregateNames = Sets.newHashSet();
        for (BoundedContext bc : this.ar.getAllBoundedContexts()) {
            aggregateNames.addAll(this.collectAggregates(bc).stream().map(agg -> agg.getName()).collect(Collectors.toSet()));
        }
        return aggregateNames;
    }

    public List<Aggregate> collectAggregates(BoundedContext bc) {
        LinkedList aggregates = Lists.newLinkedList();
        aggregates.addAll(bc.getAggregates());
        for (SculptorModule module : bc.getModules()) {
            aggregates.addAll(module.getAggregates());
        }
        return aggregates;
    }

    public Set<String> collectAllModuleNames() {
        HashSet moduleNames = Sets.newHashSet();
        for (BoundedContext bc : this.ar.getAllBoundedContexts()) {
            moduleNames.addAll(bc.getModules().stream().map(m -> m.getName()).collect(Collectors.toSet()));
        }
        return moduleNames;
    }

    public String getUniqueName(String initialName, Set<String> givenNames) {
        Object name = initialName;
        int counter = 2;
        while (givenNames.contains(name)) {
            name = initialName + "_" + counter;
            ++counter;
        }
        return name;
    }
}

