/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.List;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Coordination;
import org.contextmapper.dsl.contextMappingDSL.CoordinationStep;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ApplicationCoordinationSemanticsValidator
extends AbstractDeclarativeValidator {
    public static final String SKETCH_MINER_INFO_ID = "open-coordination-in-sketch-miner";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void stepContextIsReachableByRelationship(CoordinationStep coordinationStep) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)coordinationStep));
        BoundedContext containerContext = helper.resolveBoundedContext(coordinationStep);
        BoundedContext stepContext = coordinationStep.getBoundedContext();
        if (containerContext == null || stepContext == null || this.isNullName(stepContext.getName())) {
            return;
        }
        if (!helper.resolveAllUpstreamContexts(containerContext).contains(stepContext)) {
            this.error(String.format("The Bounded Context '%s' is not reachable through Context Map relationships. Maybe you want to create a relationship with this context?", stepContext.getName()), coordinationStep, (EStructuralFeature)ContextMappingDSLPackage.Literals.COORDINATION_STEP__BOUNDED_CONTEXT);
        }
    }

    @Check
    public void stepServiceIsApplicationService(CoordinationStep coordinationStep) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)coordinationStep));
        BoundedContext stepContext = coordinationStep.getBoundedContext();
        if (stepContext == null || this.isNullName(stepContext.getName())) {
            return;
        }
        Service stepService = coordinationStep.getService();
        if (stepService == null || this.isNullName(stepService.getName())) {
            return;
        }
        if (helper.resolveApplicationServiceByName(stepContext.getApplication(), stepService.getName()) == null) {
            this.error(String.format("The Service '%s' is not part of the Bounded Context '%s' Application.", stepService.getName(), stepContext.getName()), coordinationStep, (EStructuralFeature)ContextMappingDSLPackage.Literals.COORDINATION_STEP__SERVICE);
        }
    }

    @Check
    public void stepOperationIsPartOfStepService(CoordinationStep coordinationStep) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)coordinationStep));
        BoundedContext stepContext = coordinationStep.getBoundedContext();
        if (stepContext == null || this.isNullName(stepContext.getName())) {
            return;
        }
        Service stepService = coordinationStep.getService();
        if (stepService == null || this.isNullName(stepService.getName())) {
            return;
        }
        ServiceOperation stepOperation = coordinationStep.getOperation();
        if (stepOperation == null || this.isNullName(stepOperation.getName())) {
            return;
        }
        List<ServiceOperation> operations = helper.resolveServiceOperationsByName(stepService, stepOperation.getName());
        if (operations.isEmpty()) {
            this.error(String.format("The operation '%s' is not part of the Service '%s' of the Bounded Context '%s' Application.", stepOperation.getName(), stepService.getName(), stepContext.getName()), coordinationStep, (EStructuralFeature)ContextMappingDSLPackage.Literals.COORDINATION_STEP__OPERATION);
        }
    }

    @Check
    public void stepOperationShouldBeUniqueInStepService(CoordinationStep coordinationStep) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)coordinationStep));
        Service stepService = coordinationStep.getService();
        if (stepService == null || this.isNullName(stepService.getName())) {
            return;
        }
        ServiceOperation stepOperation = coordinationStep.getOperation();
        if (stepOperation == null || this.isNullName(stepOperation.getName())) {
            return;
        }
        List<ServiceOperation> operations = helper.resolveServiceOperationsByName(stepService, stepOperation.getName());
        if (operations.size() > 1) {
            this.warning(String.format("The reference to operation '%s' is ambiguous, since there exist multiple operations with that name in Service '%s'. We suggest keeping the operation names distinct when referencing them through Coordinations.", stepOperation.getName(), stepService.getName()), coordinationStep, (EStructuralFeature)ContextMappingDSLPackage.Literals.COORDINATION_STEP__OPERATION);
        }
    }

    @Check
    public void sketchMinerLink(Coordination coordination) {
        if (!coordination.getCoordinationSteps().isEmpty()) {
            this.info("Do you want to vizualize this coordination? You can open it in BPMN Sketch Miner ...", coordination, (EStructuralFeature)ContextMappingDSLPackage.Literals.COORDINATION__NAME, SKETCH_MINER_INFO_ID, new String[0]);
        }
    }

    private boolean isNullName(String name) {
        return name == null || "".equals(name);
    }
}

